/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.lazy;

import java.io.FilenameFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.asterix.cloud.clients.IParallelDownloader;
import org.apache.asterix.cloud.lazy.IParallelCacher;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ParallelCacher
implements IParallelCacher {
    public static final FilenameFilter METADATA_FILTER = (dir, name) -> name.startsWith(".");
    private static final Logger LOGGER = LogManager.getLogger();
    private final IParallelDownloader downloader;
    private final Set<String> uncachedIndexes;
    private final Set<FileReference> uncachedDataFiles;
    private final Set<FileReference> uncachedMetadataFiles;

    public ParallelCacher(IParallelDownloader downloader, List<FileReference> uncachedFiles) {
        this.downloader = downloader;
        this.uncachedDataFiles = ParallelCacher.getFiles(uncachedFiles, AbstractLSMIndexFileManager.COMPONENT_FILES_FILTER);
        this.uncachedMetadataFiles = ParallelCacher.getFiles(uncachedFiles, METADATA_FILTER);
        this.uncachedIndexes = this.getUncachedIndexes(uncachedFiles);
    }

    @Override
    public boolean isCached(FileReference indexDir) {
        String relativePath = indexDir.getRelativePath();
        if (relativePath.endsWith("storage") || relativePath.startsWith("mtd-txn-logs")) {
            return false;
        }
        String indexSubPath = StoragePathUtil.getIndexSubPath((FileReference)indexDir, (boolean)true);
        return !indexSubPath.isEmpty() && !this.uncachedIndexes.contains(indexSubPath);
    }

    @Override
    public Set<FileReference> getUncachedFiles(FileReference dir, FilenameFilter filter) {
        if (dir.getRelativePath().endsWith("storage")) {
            return this.uncachedDataFiles.stream().filter(f -> StoragePathUtil.hasSameStorageRoot((FileReference)dir, (FileReference)f) && filter.accept(null, f.getName())).collect(Collectors.toSet());
        }
        return this.uncachedDataFiles.stream().filter(f -> StoragePathUtil.hasSameStorageRoot((FileReference)dir, (FileReference)f) && StoragePathUtil.isRelativeParent((FileReference)dir, (FileReference)f) && filter.accept(null, f.getName())).collect(Collectors.toSet());
    }

    @Override
    public synchronized boolean downloadData(FileReference indexFile) throws HyracksDataException {
        String indexSubPath = StoragePathUtil.getIndexSubPath((FileReference)indexFile, (boolean)false);
        HashSet<FileReference> toDownload = new HashSet<FileReference>();
        for (FileReference fileReference : this.uncachedDataFiles) {
            if (!fileReference.getRelativePath().contains(indexSubPath)) continue;
            toDownload.add(fileReference.getParent());
        }
        LOGGER.debug("Downloading data files for {} in all partitions: {}", (Object)indexSubPath, toDownload);
        Collection<FileReference> failed = this.downloader.downloadDirectories(toDownload);
        if (!failed.isEmpty()) {
            LOGGER.warn("Failed to download data files {}. Re-downloading: {}", (Object)indexSubPath, failed);
            this.downloader.downloadFiles(failed);
        }
        LOGGER.debug("Finished downloading data files for {}", (Object)indexSubPath);
        this.uncachedIndexes.remove(indexSubPath);
        this.uncachedDataFiles.removeIf(f -> f.getRelativePath().contains(indexSubPath));
        return this.isEmpty();
    }

    @Override
    public synchronized boolean downloadMetadata(FileReference indexFile) throws HyracksDataException {
        String indexSubPath = StoragePathUtil.getIndexSubPath((FileReference)indexFile, (boolean)false);
        HashSet<FileReference> toDownload = new HashSet<FileReference>();
        for (FileReference fileReference : this.uncachedMetadataFiles) {
            if (!fileReference.getRelativePath().contains(indexSubPath)) continue;
            toDownload.add(fileReference);
        }
        LOGGER.debug("Downloading metadata files for {} in all partitions: {}", (Object)indexSubPath, toDownload);
        this.downloader.downloadFiles(toDownload);
        LOGGER.debug("Finished downloading metadata files for {}", (Object)indexSubPath);
        this.uncachedMetadataFiles.removeAll(toDownload);
        return this.isEmpty();
    }

    @Override
    public boolean remove(Collection<FileReference> deletedFiles) {
        LOGGER.info("Deleting {}", deletedFiles);
        for (FileReference fileReference : deletedFiles) {
            this.remove(fileReference);
        }
        return this.isEmpty();
    }

    @Override
    public boolean remove(FileReference deletedFile) {
        LOGGER.info("Deleting {}", (Object)deletedFile);
        if (AbstractLSMIndexFileManager.COMPONENT_FILES_FILTER.accept(null, deletedFile.getName())) {
            this.uncachedDataFiles.remove(deletedFile);
        } else {
            this.uncachedMetadataFiles.remove(deletedFile);
        }
        return this.isEmpty();
    }

    @Override
    public void close() {
        this.downloader.close();
        LOGGER.info("Parallel cacher was closed");
    }

    public static Set<FileReference> getFiles(List<FileReference> uncachedFiles, FilenameFilter filter) {
        ConcurrentHashMap.KeySetView fileReferences = ConcurrentHashMap.newKeySet();
        for (FileReference fileReference : uncachedFiles) {
            if (!filter.accept(null, fileReference.getName())) continue;
            fileReferences.add(fileReference);
        }
        return fileReferences;
    }

    private Set<String> getUncachedIndexes(List<FileReference> uncachedFiles) {
        ConcurrentHashMap.KeySetView uncachedIndexes = ConcurrentHashMap.newKeySet();
        for (FileReference indexFile : uncachedFiles) {
            uncachedIndexes.add(StoragePathUtil.getIndexSubPath((FileReference)indexFile, (boolean)false));
        }
        return uncachedIndexes;
    }

    private synchronized boolean isEmpty() {
        int totalSize = this.uncachedDataFiles.size() + this.uncachedMetadataFiles.size();
        LOGGER.info("Current number of uncached files {}", (Object)totalSize);
        return totalSize == 0;
    }
}

