/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.rewriter.base;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.util.LogRedactionUtil;

public abstract class AbstractRuleController {
    protected final boolean isTraceEnabled = AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled();
    protected boolean isSanityCheckEnabled;
    protected IOptimizationContext context;

    public void setContext(IOptimizationContext context) {
        this.context = context;
        this.isSanityCheckEnabled = context.getPhysicalOptimizationConfig().isSanityCheckEnabled();
    }

    public abstract boolean rewriteWithRuleCollection(Mutable<ILogicalOperator> var1, Collection<IAlgebraicRewriteRule> var2) throws AlgebricksException;

    protected boolean rewriteOperatorRef(Mutable<ILogicalOperator> opRef, IAlgebraicRewriteRule rule) throws AlgebricksException {
        return this.rewriteOperatorRef(opRef, rule, true, false, false);
    }

    protected boolean rewriteOperatorRef(Mutable<ILogicalOperator> opRef, IAlgebraicRewriteRule rule, boolean enterNestedPlans, boolean fullDFS, boolean enteredNestedPlanRoot) throws AlgebricksException {
        String preBeforePlan = this.getPlanString(opRef);
        this.sanityCheckBeforeRewrite(rule, opRef);
        rule.enteredNestedPlan(enteredNestedPlanRoot);
        if (rule.rewritePre(opRef, this.context)) {
            String preAfterPlan = this.getPlanString(opRef);
            this.printRuleApplication(rule, "fired", preBeforePlan, preAfterPlan);
            this.sanityCheckAfterRewrite(rule, opRef, true, preBeforePlan);
            return true;
        }
        this.sanityCheckAfterRewrite(rule, opRef, false, preBeforePlan);
        boolean rewritten = false;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        for (Mutable<ILogicalOperator> mutable : op.getInputs()) {
            if (!this.rewriteOperatorRef(mutable, rule, enterNestedPlans, fullDFS, false)) continue;
            rewritten = true;
            if (fullDFS) continue;
            break;
        }
        if (op.hasNestedPlans() && enterNestedPlans) {
            AbstractOperatorWithNestedPlans o2 = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : o2.getNestedPlans()) {
                for (Mutable<ILogicalOperator> r : p.getRoots()) {
                    if (!this.rewriteOperatorRef(r, rule, enterNestedPlans, fullDFS, true)) continue;
                    rewritten = true;
                    if (fullDFS) continue;
                    break;
                }
                if (!rewritten || fullDFS) continue;
                break;
            }
        }
        String postBeforePlan = this.getPlanString(opRef);
        this.sanityCheckBeforeRewrite(rule, opRef);
        if (rule.rewritePost(opRef, this.context)) {
            String string = this.getPlanString(opRef);
            this.printRuleApplication(rule, "fired", postBeforePlan, string);
            this.sanityCheckAfterRewrite(rule, opRef, true, postBeforePlan);
            return true;
        }
        this.sanityCheckAfterRewrite(rule, opRef, false, postBeforePlan);
        return rewritten;
    }

    private void sanityCheckBeforeRewrite(IAlgebraicRewriteRule rule, Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        if (this.isSanityCheckEnabled) {
            this.sanityCheckBeforeRewriteImpl(rule, opRef);
        }
    }

    private void sanityCheckAfterRewrite(IAlgebraicRewriteRule rule, Mutable<ILogicalOperator> opRef, boolean rewritten, String beforePlan) throws AlgebricksException {
        if (this.isSanityCheckEnabled) {
            this.sanityCheckAfterRewriteImpl(rule, opRef, rewritten, beforePlan);
        }
    }

    private void sanityCheckBeforeRewriteImpl(IAlgebraicRewriteRule rule, Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        try {
            this.context.getPlanStabilityVerifier().recordPlanSignature(opRef);
        }
        catch (AlgebricksException e) {
            throw AlgebricksException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{String.format("Illegal state before rule %s. %s", rule.getClass().getName(), e.getMessage())});
        }
    }

    private void sanityCheckAfterRewriteImpl(IAlgebraicRewriteRule rule, Mutable<ILogicalOperator> opRef, boolean rewritten, String beforePlan) throws AlgebricksException {
        if (rewritten) {
            try {
                this.context.getPlanStructureVerifier().verifyPlanStructure(opRef);
            }
            catch (AlgebricksException e) {
                throw AlgebricksException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{String.format("Fired rule %s produced illegal %s", rule.getClass().getName(), e.getMessage())});
            }
        }
        try {
            this.context.getPlanStabilityVerifier().comparePlanSignature(opRef);
        }
        catch (AlgebricksException e) {
            if (this.isTraceEnabled) {
                this.printRuleApplication(rule, "not fired, but failed sanity check: " + e.getMessage(), beforePlan, this.getPlanString(opRef));
            }
            throw AlgebricksException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{String.format("Non-fired rule %s unexpectedly %s", rule.getClass().getName(), e.getMessage())});
        }
        this.context.getPlanStabilityVerifier().discardPlanSignature();
    }

    private String getPlanString(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        if (this.isTraceEnabled && this.context != null) {
            IPlanPrettyPrinter prettyPrinter = this.context.getPrettyPrinter();
            return prettyPrinter.reset().printOperator((AbstractLogicalOperator)opRef.getValue()).toString();
        }
        return null;
    }

    private void printRuleApplication(IAlgebraicRewriteRule rule, String status, String beforePlan, String afterPlan) {
        if (this.isTraceEnabled) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">> Rule " + rule.getClass().getName() + " " + status + "\n");
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">> Before plan\n" + LogRedactionUtil.userData((String)beforePlan) + "\n");
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace(">> After plan\n" + LogRedactionUtil.userData((String)afterPlan) + "\n");
        }
    }
}

