/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.net.URI;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public final class CreateLibraryStatement
extends AbstractStatement {
    private final Namespace namespace;
    private final String libraryName;
    private final ExternalFunctionLanguage lang;
    private final String hash;
    private final URI location;
    private final boolean replaceIfExists;
    private final String authToken;

    public CreateLibraryStatement(Namespace namespace, String libraryName, ExternalFunctionLanguage lang, String hash, URI location, boolean replaceIfExists, String authToken) {
        this.namespace = namespace;
        this.libraryName = libraryName;
        this.lang = lang;
        this.location = location;
        this.replaceIfExists = replaceIfExists;
        this.authToken = authToken;
        this.hash = hash;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public DataverseName getDataverseName() {
        return this.namespace == null ? null : this.namespace.getDataverseName();
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public ExternalFunctionLanguage getLang() {
        return this.lang;
    }

    public String getHash() {
        return this.hash;
    }

    public URI getLocation() {
        return this.location;
    }

    public boolean getReplaceIfExists() {
        return this.replaceIfExists;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CREATE_LIBRARY;
    }

    @Override
    public byte getCategory() {
        return 4;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }
}

