/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.INumeric;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.FixedLengthTypeTrait;
import org.apache.hyracks.data.std.util.DataUtils;

public final class BytePointable
extends AbstractPointable
implements IHashable,
IComparable,
INumeric {
    private static final int SIZE = 1;
    public static final BytePointableFactory FACTORY = new BytePointableFactory();
    public static final ITypeTraits TYPE_TRAITS = new FixedLengthTypeTrait(1);

    public static byte getByte(byte[] bytes, int start) {
        return bytes[start];
    }

    public static void setByte(byte[] bytes, int start, byte value) {
        bytes[start] = value;
    }

    public byte getByte() {
        return BytePointable.getByte(this.bytes, this.start);
    }

    public void setByte(byte value) {
        BytePointable.setByte(this.bytes, this.start, value);
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        return BytePointable.compare(this.bytes, this.start, this.length, bytes, start, length);
    }

    public static int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        DataUtils.ensureLengths(1, l1, l2);
        return Byte.compare(BytePointable.getByte(b1, s1), BytePointable.getByte(b2, s2));
    }

    @Override
    public int hash() {
        return this.getByte();
    }

    @Override
    public byte byteValue() {
        return this.getByte();
    }

    @Override
    public short shortValue() {
        return this.getByte();
    }

    @Override
    public int intValue() {
        return this.getByte();
    }

    @Override
    public long longValue() {
        return this.getByte();
    }

    @Override
    public float floatValue() {
        return this.getByte();
    }

    @Override
    public double doubleValue() {
        return this.getByte();
    }

    public static final class BytePointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public IPointable createPointable() {
            return new BytePointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

