/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentClassLoader;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ModuleDeployer;
import org.apache.axis2.deployment.RepositoryListener;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.ServiceBuilderExtension;
import org.apache.axis2.deployment.ServiceDeployer;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.repository.util.WSInfo;
import org.apache.axis2.deployment.scheduler.DeploymentIterator;
import org.apache.axis2.deployment.scheduler.Scheduler;
import org.apache.axis2.deployment.scheduler.SchedulerTask;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.FaultyServiceData;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DeploymentEngine
implements DeploymentConstants {
    private static final Log log = LogFactory.getLog(DeploymentEngine.class);
    public static final String DEPLOYMENT_TASK_RUNNING = "deployment.task.running";
    private static final String MODULE_DEPLOYER = "moduleDeployer";
    protected static String webLocationString = null;
    protected Scheduler scheduler;
    private SchedulerTask schedulerTask;
    protected boolean hotUpdate = true;
    protected boolean hotDeployment = true;
    protected List<DeploymentFileData> wsToDeploy = new ArrayList<DeploymentFileData>();
    protected List<WSInfo> wsToUnDeploy = new ArrayList<WSInfo>();
    protected AxisConfiguration axisConfig;
    protected ConfigurationContext configContext;
    protected RepositoryListener repoListener;
    protected String servicesPath = null;
    protected File servicesDir = null;
    protected String modulesPath = null;
    protected File modulesDir = null;
    private File repositoryDir = null;
    protected ServiceDeployer serviceDeployer;
    protected ModuleDeployer moduleDeployer;
    private Map<String, Map<String, Deployer>> deployerMap = new HashMap<String, Map<String, Deployer>>();
    private Lock lock = new ReentrantLock();

    public static void setWebLocationString(String webLocationString) {
        DeploymentEngine.webLocationString = webLocationString;
    }

    public void loadServices() {
        this.repoListener.checkServices();
        if (this.hotDeployment) {
            this.startSearch(this.repoListener);
        }
    }

    public void loadRepository(String repoDir) throws DeploymentException {
        File axisRepo = new File(repoDir);
        if (!axisRepo.exists()) {
            throw new DeploymentException(Messages.getMessage("cannotfindrepo", repoDir));
        }
        this.setDeploymentFeatures();
        this.prepareRepository(repoDir);
        this.setClassLoaders(repoDir);
        this.repoListener = new RepositoryListener(this, false);
        org.apache.axis2.util.Utils.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
        try {
            try {
                this.axisConfig.setRepository(axisRepo.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.info((Object)e.getMessage());
            }
            this.axisConfig.validateSystemPredefinedPhases();
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
    }

    public void loadFromClassPath() throws DeploymentException {
        new RepositoryListener(this, true);
        org.apache.axis2.util.Utils.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
        this.axisConfig.validateSystemPredefinedPhases();
        try {
            this.engageModules();
        }
        catch (AxisFault axisFault) {
            log.info((Object)Messages.getMessage("modulevalfailed", axisFault.getMessage()));
            throw new DeploymentException(axisFault);
        }
    }

    private void loadCustomServices(URL repoURL) {
        for (Map.Entry<String, Map<String, Deployer>> entry : this.getDeployers().entrySet()) {
            String directory = entry.getKey();
            Map<String, Deployer> extensionMap = entry.getValue();
            try {
                String listName;
                if (!directory.endsWith("/")) {
                    listName = directory + ".list";
                    directory = directory + "/";
                } else {
                    listName = directory.replaceAll("/", "") + ".list";
                }
                String repoPath = repoURL.getPath();
                if (!repoPath.endsWith("/")) {
                    repoPath = repoPath + "/";
                    repoURL = new URL(repoURL.getProtocol() + "://" + repoPath);
                }
                URL servicesDir = new URL(repoURL, directory);
                URL filelisturl = new URL(servicesDir, listName);
                ArrayList<String> files = this.getFileList(filelisturl);
                for (Object e : files) {
                    String fileName = (String)e;
                    String extension = this.getExtension(fileName);
                    Deployer deployer = extensionMap.get(extension);
                    if (deployer == null) continue;
                    URL servicesURL = new URL(servicesDir, fileName);
                    Class<?> classToLoad = deployer.getClass();
                    Method method = null;
                    try {
                        method = classToLoad.getMethod("deployFromURL", URL.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (method == null) continue;
                    try {
                        method.invoke((Object)deployer, servicesURL);
                    }
                    catch (Exception e2) {
                        log.info((Object)("Exception trying to call deployFromURL for the deployer" + deployer.getClass()), (Throwable)e2);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
    }

    private String getExtension(String fileName) {
        int lastIndex = fileName.lastIndexOf(".");
        return fileName.substring(lastIndex + 1);
    }

    public void loadServicesFromUrl(URL repoURL) {
        try {
            String repoPath;
            String path;
            String string = path = this.servicesPath == null ? "services" : this.servicesPath;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (!(repoPath = repoURL.getPath()).endsWith("/")) {
                repoPath = repoPath + "/";
                repoURL = new URL(repoURL.getProtocol() + "://" + repoPath);
            }
            URL servicesDir = new URL(repoURL, path);
            URL filelisturl = new URL(servicesDir, "services.list");
            ArrayList<String> files = this.getFileList(filelisturl);
            this.repoListener = new RepositoryListener(this, false);
            for (String file : files) {
                String fileUrl = file;
                if (!fileUrl.endsWith(".aar")) continue;
                URL servicesURL = new URL(servicesDir, fileUrl);
                this.repoListener.addURLToDeploy(servicesURL, this.getServiceDeployer(), 0);
            }
            this.repoListener.update();
            this.loadCustomServices(repoURL);
        }
        catch (MalformedURLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void loadRepositoryFromURL(URL repoURL) throws DeploymentException {
        try {
            String repoPath;
            String path;
            this.setDeploymentFeatures();
            String string = path = this.modulesPath == null ? "modules" : this.modulesPath;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (!(repoPath = repoURL.getPath()).endsWith("/")) {
                repoPath = repoPath + "/";
                repoURL = new URL(repoURL.getProtocol() + "://" + repoPath);
            }
            URL moduleDir = new URL(repoURL, path);
            URL filelisturl = new URL(moduleDir, "modules.list");
            Iterator<String> fileIterator = this.getFileList(filelisturl).iterator();
            this.axisConfig.setRepository(repoURL);
            this.repoListener = new RepositoryListener(this, false);
            while (fileIterator.hasNext()) {
                String fileUrl = fileIterator.next();
                if (!fileUrl.endsWith(".mar")) continue;
                URL moduleurl = new URL(moduleDir, fileUrl);
                this.repoListener.addURLToDeploy(moduleurl, this.getModuleDeployer(), 1);
            }
            this.repoListener.update();
            org.apache.axis2.util.Utils.calculateDefaultModuleVersion(this.axisConfig.getModules(), this.axisConfig);
            this.axisConfig.validateSystemPredefinedPhases();
        }
        catch (MalformedURLException e) {
            throw new DeploymentException(e);
        }
        catch (IOException e) {
            throw new DeploymentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNewModule(AxisModule modulemetadata, AxisConfiguration axisConfiguration) throws AxisFault {
        Flow faultOutFlow;
        Flow faultInFlow;
        Flow outFlow;
        Flow inflow = modulemetadata.getInFlow();
        ClassLoader moduleClassLoader = modulemetadata.getModuleClassLoader();
        if (inflow != null) {
            Utils.addFlowHandlers(inflow, moduleClassLoader);
        }
        if ((outFlow = modulemetadata.getOutFlow()) != null) {
            Utils.addFlowHandlers(outFlow, moduleClassLoader);
        }
        if ((faultInFlow = modulemetadata.getFaultInFlow()) != null) {
            Utils.addFlowHandlers(faultInFlow, moduleClassLoader);
        }
        if ((faultOutFlow = modulemetadata.getFaultOutFlow()) != null) {
            Utils.addFlowHandlers(faultOutFlow, moduleClassLoader);
        }
        axisConfiguration.addModule(modulemetadata);
        log.debug((Object)Messages.getMessage("addingnewmodule"));
        Map<String, Map<String, FaultyServiceData>> map = axisConfiguration.getFaultyServicesDuetoModules();
        synchronized (map) {
            HashMap faultyServices = (HashMap)axisConfiguration.getFaultyServicesDuetoModule(modulemetadata.getName());
            faultyServices = (HashMap)faultyServices.clone();
            for (FaultyServiceData faultyServiceData : faultyServices.values()) {
                axisConfiguration.removeFaultyServiceDuetoModule(modulemetadata.getName(), faultyServiceData.getServiceGroup().getServiceGroupName());
                DeploymentEngine.addServiceGroup(faultyServiceData.getServiceGroup(), faultyServiceData.getServiceList(), faultyServiceData.getServiceLocation(), faultyServiceData.getCurrentDeploymentFile(), axisConfiguration);
            }
        }
    }

    public static void addServiceGroup(AxisServiceGroup serviceGroup, ArrayList<AxisService> serviceList, URL serviceLocation, DeploymentFileData currentDeploymentFile, AxisConfiguration axisConfiguration) throws AxisFault {
        if (DeploymentEngine.isServiceGroupReadyToDeploy(serviceGroup, serviceList, serviceLocation, currentDeploymentFile, axisConfiguration)) {
            DeploymentEngine.fillServiceGroup(serviceGroup, serviceList, serviceLocation, axisConfiguration);
            axisConfiguration.addServiceGroup(serviceGroup);
            if (currentDeploymentFile != null) {
                DeploymentEngine.addAsWebResources(currentDeploymentFile.getFile(), serviceGroup.getServiceGroupName(), serviceGroup);
                if (!JavaUtils.isTrueExplicitly(serviceGroup.getParameterValue("hiddenService"))) {
                    log.info((Object)Messages.getMessage("deployingws", currentDeploymentFile.getName(), serviceLocation.toString()));
                }
            } else if (!JavaUtils.isTrueExplicitly(serviceGroup.getParameterValue("hiddenService"))) {
                log.info((Object)Messages.getMessage("deployingws", serviceGroup.getServiceGroupName(), ""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isServiceGroupReadyToDeploy(AxisServiceGroup serviceGroup, ArrayList<AxisService> serviceList, URL serviceLocation, DeploymentFileData currentDeploymentFile, AxisConfiguration axisConfig) throws AxisFault {
        Map<String, Map<String, FaultyServiceData>> map = axisConfig.getFaultyServicesDuetoModules();
        synchronized (map) {
            String moduleName;
            ArrayList<String> groupModules = serviceGroup.getModuleRefs();
            for (String string : groupModules) {
                moduleName = string;
                AxisModule module = axisConfig.getModule(moduleName);
                if (module != null) continue;
                axisConfig.addFaultyServiceDuetoModule(moduleName, new FaultyServiceData(serviceGroup, serviceList, serviceLocation, currentDeploymentFile));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Service: " + serviceGroup.getServiceGroupName() + " becomes faulty due to Module: " + moduleName));
                }
                return false;
            }
            for (Object object : serviceList) {
                AxisService axisService = (AxisService)object;
                ArrayList<String> list = axisService.getModules();
                for (String aList : list) {
                    moduleName = aList;
                    AxisModule module = axisConfig.getModule(moduleName);
                    if (module != null) continue;
                    axisConfig.addFaultyServiceDuetoModule(moduleName, new FaultyServiceData(serviceGroup, serviceList, serviceLocation, currentDeploymentFile));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Service: " + serviceGroup.getServiceGroupName() + " becomes faulty due to Module: " + moduleName));
                    }
                    return false;
                }
                Iterator<AxisOperation> iterator = axisService.getOperations();
                while (iterator.hasNext()) {
                    AxisOperation opDesc = iterator.next();
                    ArrayList<String> modules = opDesc.getModuleRefs();
                    for (String module1 : modules) {
                        moduleName = module1;
                        AxisModule module = axisConfig.getModule(moduleName);
                        if (module != null) continue;
                        axisConfig.addFaultyServiceDuetoModule(moduleName, new FaultyServiceData(serviceGroup, serviceList, serviceLocation, currentDeploymentFile));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Service: " + serviceGroup.getServiceGroupName() + " becomes faulty due to Module: " + moduleName));
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected static void fillServiceGroup(AxisServiceGroup serviceGroup, ArrayList<AxisService> serviceList, URL serviceLocation, AxisConfiguration axisConfig) throws AxisFault {
        ArrayList<String> groupModules = serviceGroup.getModuleRefs();
        serviceGroup.setParent(axisConfig);
        for (String groupModule : groupModules) {
            String moduleName = groupModule;
            AxisModule module = axisConfig.getModule(moduleName);
            if (module != null) {
                serviceGroup.engageModule(axisConfig.getModule(moduleName));
                continue;
            }
            throw new DeploymentException(Messages.getMessage("badModuleFromService", serviceGroup.getServiceGroupName(), moduleName));
        }
        for (AxisService axisService : serviceList) {
            axisService.setUseDefaultChains(false);
            axisService.setFileName(serviceLocation);
            serviceGroup.addService(axisService);
            ArrayList<String> list = axisService.getModules();
            for (Object e : list) {
                AxisModule module = axisConfig.getModule((String)e);
                if (module == null) {
                    throw new DeploymentException(Messages.getMessage("badModuleFromService", axisService.getName(), ((QName)e).getLocalPart()));
                }
                axisService.engageModule(module);
            }
            Iterator<AxisOperation> iterator = axisService.getOperations();
            while (iterator.hasNext()) {
                AxisOperation axisOperation = iterator.next();
                ArrayList<String> modules = axisOperation.getModuleRefs();
                for (String module1 : modules) {
                    String moduleName = module1;
                    AxisModule module = axisConfig.getModule(moduleName);
                    if (module != null) {
                        axisOperation.engageModule(module);
                        continue;
                    }
                    throw new DeploymentException(Messages.getMessage("badModuleFromOperation", axisOperation.getName().getLocalPart(), moduleName));
                }
            }
        }
    }

    public synchronized void addWSToDeploy(DeploymentFileData file) {
        this.wsToDeploy.add(file);
    }

    public synchronized void addWSToUndeploy(WSInfo file) {
        this.wsToUnDeploy.add(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doDeploy() {
        try {
            if (this.wsToDeploy.size() > 0) {
                Iterator<DeploymentFileData> iterator = this.wsToDeploy.iterator();
                while (iterator.hasNext()) {
                    DeploymentFileData aWsToDeploy;
                    DeploymentFileData fileToDeploy = aWsToDeploy = iterator.next();
                    try {
                        fileToDeploy.deploy();
                    }
                    catch (DeploymentException e) {
                        log.info((Object)e);
                    }
                }
            }
        }
        finally {
            this.wsToDeploy.clear();
        }
    }

    public void engageModules() throws AxisFault {
        this.axisConfig.engageGlobalModules();
    }

    public AxisConfiguration populateAxisConfiguration(InputStream in) throws DeploymentException {
        this.axisConfig = new AxisConfiguration();
        AxisConfigBuilder builder = new AxisConfigBuilder(in, this.axisConfig, this);
        builder.populateConfig();
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            log.info((Object)"error in closing input stream");
        }
        this.moduleDeployer = new ModuleDeployer(this.axisConfig);
        return this.axisConfig;
    }

    protected void startSearch(RepositoryListener listener) {
        this.scheduler = new Scheduler();
        this.schedulerTask = new SchedulerTask(listener, this.axisConfig);
        this.scheduler.schedule(this.schedulerTask, new DeploymentIterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeploymentTaskRunning() {
        AxisConfiguration axisConfiguration = this.axisConfig;
        synchronized (axisConfiguration) {
            Parameter deploymentTaskRunningParam = this.axisConfig.getParameter(DEPLOYMENT_TASK_RUNNING);
            if (deploymentTaskRunningParam != null) {
                return (Boolean)deploymentTaskRunningParam.getValue();
            }
            return false;
        }
    }

    public synchronized void unDeploy() {
        try {
            if (this.wsToUnDeploy.size() > 0) {
                for (WSInfo aWsToUnDeploy : this.wsToUnDeploy) {
                    WSInfo wsInfo = aWsToUnDeploy;
                    if (wsInfo.getType() == 0) {
                        this.serviceDeployer.undeploy(wsInfo.getFileName());
                        continue;
                    }
                    Deployer deployer = wsInfo.getDeployer();
                    if (deployer == null) continue;
                    deployer.undeploy(wsInfo.getFileName());
                }
            }
        }
        catch (Exception e) {
            log.info((Object)e);
        }
        this.wsToUnDeploy.clear();
    }

    public AxisConfiguration getAxisConfig() {
        return this.axisConfig;
    }

    public static String getAxisServiceName(String fileName) {
        int seperator = 46;
        int index = fileName.lastIndexOf(seperator);
        if (index > 0) {
            String value = fileName.substring(0, index);
            return value;
        }
        return fileName;
    }

    public AxisModule getModule(String moduleName) throws AxisFault {
        return this.axisConfig.getModule(moduleName);
    }

    public boolean isHotUpdate() {
        return this.hotUpdate;
    }

    private static void addAsWebResources(File in, String serviceFileName, AxisServiceGroup serviceGroup) {
        try {
            ZipEntry entry;
            if (webLocationString == null) {
                return;
            }
            if (in.isDirectory()) {
                return;
            }
            File webLocation = new File(webLocationString);
            File out = new File(webLocation, serviceFileName);
            int BUFFER = 1024;
            byte[] data = new byte[BUFFER];
            FileInputStream fin = new FileInputStream(in);
            ZipInputStream zin = new ZipInputStream(fin);
            while ((entry = zin.getNextEntry()) != null) {
                ZipEntry zip = new ZipEntry(entry);
                if (!zip.getName().toUpperCase().startsWith("WWW")) continue;
                String fileName = zip.getName();
                fileName = fileName.substring("WWW/".length(), fileName.length());
                if (zip.isDirectory()) {
                    new File(out, fileName).mkdirs();
                } else {
                    int count;
                    FileOutputStream tempOut = new FileOutputStream(new File(out, fileName));
                    while ((count = zin.read(data, 0, BUFFER)) != -1) {
                        tempOut.write(data, 0, count);
                    }
                    tempOut.close();
                    tempOut.flush();
                }
                serviceGroup.setFoundWebResources(true);
            }
            zin.close();
            fin.close();
        }
        catch (IOException e) {
            log.info((Object)e.getMessage());
        }
    }

    public static String getWebLocationString() {
        return webLocationString;
    }

    protected void setClassLoaders(String axis2repoURI) throws DeploymentException {
        if (this.axisConfig.getSystemClassLoader() == null) {
            ClassLoader sysClassLoader = Utils.getClassLoader(Thread.currentThread().getContextClassLoader(), axis2repoURI, this.axisConfig.isChildFirstClassLoading());
            this.axisConfig.setSystemClassLoader(sysClassLoader);
        }
        if (this.servicesDir.exists()) {
            this.axisConfig.setServiceClassLoader(Utils.getClassLoader(this.axisConfig.getSystemClassLoader(), this.servicesDir, this.axisConfig.isChildFirstClassLoading()));
        } else {
            this.axisConfig.setServiceClassLoader(this.axisConfig.getSystemClassLoader());
        }
        if (this.modulesDir.exists()) {
            this.axisConfig.setModuleClassLoader(Utils.getClassLoader(this.axisConfig.getSystemClassLoader(), this.modulesDir, this.axisConfig.isChildFirstClassLoading()));
        } else {
            this.axisConfig.setModuleClassLoader(this.axisConfig.getSystemClassLoader());
        }
    }

    protected void setDeploymentFeatures() {
        String moduleDirPara;
        String serviceDirPara;
        Parameter hotDeployment = this.axisConfig.getParameter("hotdeployment");
        Parameter hotUpdate = this.axisConfig.getParameter("hotupdate");
        if (hotDeployment != null) {
            this.hotDeployment = JavaUtils.isTrue(hotDeployment.getValue(), true);
        }
        if (hotUpdate != null) {
            this.hotUpdate = JavaUtils.isTrue(hotUpdate.getValue(), true);
        }
        if ((serviceDirPara = (String)this.axisConfig.getParameterValue("ServicesDirectory")) != null) {
            this.servicesPath = serviceDirPara;
        }
        if ((moduleDirPara = (String)this.axisConfig.getParameterValue("ModulesDirectory")) != null) {
            this.modulesPath = moduleDirPara;
        }
    }

    protected void prepareRepository(String repositoryName) {
        this.repositoryDir = new File(repositoryName);
        if (this.servicesPath != null) {
            this.servicesDir = new File(this.servicesPath);
            if (!this.servicesDir.exists()) {
                this.servicesDir = new File(this.repositoryDir, this.servicesPath);
            }
        } else {
            this.servicesDir = new File(this.repositoryDir, "services");
        }
        if (!this.servicesDir.exists()) {
            log.info((Object)Messages.getMessage("noservicedirfound", this.getRepositoryPath(this.repositoryDir)));
        }
        if (this.modulesPath != null) {
            this.modulesDir = new File(this.modulesPath);
            if (!this.modulesDir.exists()) {
                this.modulesDir = new File(this.repositoryDir, this.modulesPath);
            }
        } else {
            this.modulesDir = new File(this.repositoryDir, "modules");
        }
        if (!this.modulesDir.exists()) {
            log.info((Object)Messages.getMessage("nomoduledirfound", this.getRepositoryPath(this.repositoryDir)));
        }
    }

    protected String getRepositoryPath(File repository) {
        try {
            return repository.getCanonicalPath();
        }
        catch (IOException e) {
            return repository.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<String> getFileList(URL fileListUrl) {
        InputStream in;
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            in = fileListUrl.openStream();
        }
        catch (IOException e) {
            log.info((Object)(e.getMessage() + " -  as per axis2.repository.url, the URL is " + fileListUrl + " that will be used relative to " + new File(".").getAbsolutePath()));
            return fileList;
        }
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new InputStreamReader(in));
            while ((line = input.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                fileList.add(line);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return fileList;
    }

    public void setConfigContext(ConfigurationContext configContext) {
        this.configContext = configContext;
        this.initializeDeployers(this.configContext);
    }

    private void initializeDeployers(ConfigurationContext configContext) {
        for (Map<String, Deployer> extensionMap : this.deployerMap.values()) {
            for (Deployer deployer : extensionMap.values()) {
                deployer.init(configContext);
                if (!(deployer instanceof AbstractDeployer)) continue;
                for (ServiceBuilderExtension builderExtension : ((AbstractDeployer)deployer).getServiceBuilderExtensions()) {
                    builderExtension.init(configContext);
                    ((AbstractDeployer)deployer).addServiceBuilderExtensions(builderExtension);
                }
                if (!(deployer instanceof ServiceDeployer)) continue;
                this.serviceDeployer = (ServiceDeployer)deployer;
            }
        }
    }

    public static AxisModule buildModule(File modulearchive, AxisConfiguration config) throws DeploymentException {
        AxisModule axismodule;
        ModuleDeployer deployer = (ModuleDeployer)config.getParameterValue(MODULE_DEPLOYER);
        try {
            Flow faultOutFlow;
            Flow faultInFlow;
            Flow outFlow;
            if (deployer == null) {
                deployer = new ModuleDeployer(config);
                config.addParameter(MODULE_DEPLOYER, deployer);
            }
            DeploymentFileData currentDeploymentFile = new DeploymentFileData(modulearchive, deployer);
            axismodule = new AxisModule();
            ArchiveReader archiveReader = new ArchiveReader();
            currentDeploymentFile.setClassLoader(false, config.getModuleClassLoader(), null, config.isChildFirstClassLoading());
            axismodule.setModuleClassLoader(currentDeploymentFile.getClassLoader());
            archiveReader.readModuleArchive(currentDeploymentFile, axismodule, false, config);
            ClassLoader moduleClassLoader = axismodule.getModuleClassLoader();
            Flow inflow = axismodule.getInFlow();
            if (inflow != null) {
                Utils.addFlowHandlers(inflow, moduleClassLoader);
            }
            if ((outFlow = axismodule.getOutFlow()) != null) {
                Utils.addFlowHandlers(outFlow, moduleClassLoader);
            }
            if ((faultInFlow = axismodule.getFaultInFlow()) != null) {
                Utils.addFlowHandlers(faultInFlow, moduleClassLoader);
            }
            if ((faultOutFlow = axismodule.getFaultOutFlow()) != null) {
                Utils.addFlowHandlers(faultOutFlow, moduleClassLoader);
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
        return axismodule;
    }

    public static AxisService buildService(InputStream serviceInputStream, ConfigurationContext configCtx) throws DeploymentException {
        AxisService axisService = new AxisService();
        try {
            ServiceBuilder builder = new ServiceBuilder(serviceInputStream, configCtx, axisService);
            builder.populateService(builder.buildOM());
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(axisFault);
        }
        catch (XMLStreamException e) {
            throw new DeploymentException(e);
        }
        return axisService;
    }

    public static AxisServiceGroup buildServiceGroup(InputStream servicesxml, ClassLoader classLoader, String serviceGroupName, ConfigurationContext configCtx, ArchiveReader archiveReader, HashMap<String, AxisService> wsdlServices) throws AxisFault {
        DeploymentFileData currentDeploymentFile = new DeploymentFileData(null, null);
        currentDeploymentFile.setClassLoader(classLoader);
        AxisServiceGroup serviceGroup = new AxisServiceGroup();
        serviceGroup.setServiceGroupClassLoader(classLoader);
        serviceGroup.setServiceGroupName(serviceGroupName);
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        try {
            ArrayList<AxisService> serviceList = archiveReader.buildServiceGroup(servicesxml, currentDeploymentFile, serviceGroup, wsdlServices, configCtx);
            DeploymentEngine.fillServiceGroup(serviceGroup, serviceList, null, axisConfig);
            return serviceGroup;
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault(e);
        }
    }

    public static AxisServiceGroup loadServiceGroup(File serviceFile, ConfigurationContext configCtx) throws AxisFault {
        try {
            DeploymentFileData currentDeploymentFile = new DeploymentFileData(serviceFile, null);
            DeploymentClassLoader classLoader = Utils.createClassLoader(serviceFile, configCtx.getAxisConfiguration().isChildFirstClassLoading());
            currentDeploymentFile.setClassLoader(classLoader);
            AxisServiceGroup serviceGroup = new AxisServiceGroup();
            serviceGroup.setServiceGroupClassLoader(classLoader);
            String fileName = serviceFile.getName();
            String serviceGroupName = fileName.substring(0, fileName.lastIndexOf("."));
            serviceGroup.setServiceGroupName(serviceGroupName);
            AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
            ArchiveReader archiveReader = new ArchiveReader();
            HashMap<String, AxisService> wsdlServices = archiveReader.processWSDLs(currentDeploymentFile);
            InputStream serviceXml = classLoader.getResourceAsStream("META-INF/services.xml");
            ArrayList<AxisService> serviceList = archiveReader.buildServiceGroup(serviceXml, currentDeploymentFile, serviceGroup, wsdlServices, configCtx);
            DeploymentEngine.fillServiceGroup(serviceGroup, serviceList, null, axisConfig);
            return serviceGroup;
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    public File getServicesDir() {
        return this.servicesDir;
    }

    public File getModulesDir() {
        return this.modulesDir;
    }

    public File getRepositoryDir() {
        return this.repositoryDir;
    }

    public void setDeployers(Map<String, Map<String, Deployer>> deployerMap) {
        this.deployerMap = deployerMap;
    }

    public Map<String, Map<String, Deployer>> getDeployers() {
        return this.deployerMap;
    }

    public RepositoryListener getRepoListener() {
        return this.repoListener;
    }

    public ServiceDeployer getServiceDeployer() {
        return this.serviceDeployer;
    }

    public ModuleDeployer getModuleDeployer() {
        return this.moduleDeployer;
    }

    public Deployer getDeployer(String directory, String extension) {
        Map<String, Deployer> extensionMap = this.deployerMap.get(directory);
        return extensionMap != null ? extensionMap.get(extension) : null;
    }

    private static void destroyClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof DeploymentClassLoader) {
            try {
                ((DeploymentClassLoader)classLoader).close();
            }
            catch (IOException ex) {
                log.warn((Object)("Failed to destroy class loader " + classLoader), (Throwable)ex);
            }
        }
    }

    public void cleanup() {
        DeploymentEngine.destroyClassLoader(this.axisConfig.getModuleClassLoader());
        DeploymentEngine.destroyClassLoader(this.axisConfig.getServiceClassLoader());
        DeploymentEngine.destroyClassLoader(this.axisConfig.getSystemClassLoader());
        if (this.scheduler != null) {
            this.scheduler.cleanup(this.schedulerTask);
        }
        for (Map<String, Deployer> stringDeployerMap : this.deployerMap.values()) {
            for (Deployer deployer : stringDeployerMap.values()) {
                try {
                    deployer.cleanup();
                }
                catch (DeploymentException e) {
                    log.error((Object)"Error occurred while cleaning up deployer", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeployer(Deployer deployer, String directory, String extension) {
        if (deployer == null) {
            log.error((Object)"Failed to add Deployer : deployer is null");
            return;
        }
        if (directory == null) {
            log.error((Object)("Failed to add Deployer " + deployer.getClass().getName() + ": missing 'directory' attribute"));
            return;
        }
        if (extension != null && extension.charAt(0) == '.') {
            extension = extension.substring(1);
        }
        if (this.configContext != null) {
            deployer.init(this.configContext);
            Iterator<ServiceBuilderExtension> sbeItr = ((AbstractDeployer)deployer).getServiceBuilderExtensions().iterator();
            while (sbeItr.hasNext()) {
                sbeItr.next().init(this.configContext);
            }
            if (!this.hotDeployment) {
                // empty if block
            }
        }
        this.lock.lock();
        try {
            Map<String, Deployer> extensionMap = this.deployerMap.get(directory);
            if (extensionMap == null) {
                extensionMap = new HashMap<String, Deployer>();
                this.deployerMap.put(directory, extensionMap);
            }
            extensionMap.put(extension, deployer);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeployer(String directory, String extension) {
        if (directory == null) {
            log.error((Object)"Failed to remove Deployer : missing 'directory' attribute");
            return;
        }
        if (extension == null) {
            log.error((Object)"Failed to remove Deployer : Deployer missing 'extension' attribute");
            return;
        }
        Map<String, Deployer> extensionMap = this.deployerMap.get(directory);
        if (extensionMap == null) {
            return;
        }
        this.lock.lock();
        try {
            if (extensionMap.containsKey(extension)) {
                Deployer deployer = extensionMap.remove(extension);
                if (extensionMap.isEmpty()) {
                    this.deployerMap.remove(directory);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deployer " + deployer.getClass().getName() + " is removed"));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

