/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.xmpp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.xmpp.util.XMPPClientResponseManager;
import org.apache.axis2.transport.xmpp.util.XMPPConnectionFactory;
import org.apache.axis2.transport.xmpp.util.XMPPOutTransportInfo;
import org.apache.axis2.transport.xmpp.util.XMPPServerCredentials;
import org.apache.axis2.transport.xmpp.util.XMPPUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAllMember;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;

public class XMPPSender
extends AbstractHandler
implements TransportSender {
    static Log log = null;
    XMPPServerCredentials serverCredentials;
    private XMPPClientResponseManager xmppClientSidePacketListener;
    private XMPPConnectionFactory defaultConnectionFactory;

    public XMPPSender() {
        log = LogFactory.getLog(XMPPSender.class);
        this.xmppClientSidePacketListener = new XMPPClientResponseManager();
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
        this.serverCredentials = new XMPPServerCredentials();
        this.getConnectionDetailsFromAxisConfiguration(transportOut);
        this.defaultConnectionFactory = new XMPPConnectionFactory();
    }

    public void stop() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        String targetAddress = (String)msgContext.getProperty("TransportURL");
        if (targetAddress != null) {
            this.sendMessage(msgContext, targetAddress, null);
            return Handler.InvocationResponse.CONTINUE;
        } else if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            targetAddress = msgContext.getTo().getAddress();
            if (msgContext.getTo().hasNoneAddress()) return Handler.InvocationResponse.CONTINUE;
            this.sendMessage(msgContext, targetAddress, null);
            return Handler.InvocationResponse.CONTINUE;
        } else {
            if (!msgContext.isServerSide()) return Handler.InvocationResponse.CONTINUE;
            this.sendMessage(msgContext, null, (OutTransportInfo)msgContext.getProperty("OutTransportInfo"));
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgCtx, String targetAddress, OutTransportInfo outTransportInfo) throws AxisFault {
        XMPPConnectionFactory connectionFactory;
        XMPPConnection xmppConnection = null;
        XMPPOutTransportInfo xmppOutTransportInfo = null;
        if (msgCtx.isServerSide()) {
            xmppOutTransportInfo = (XMPPOutTransportInfo)msgCtx.getProperty("OutTransportInfo");
            connectionFactory = xmppOutTransportInfo.getConnectionFactory();
        } else {
            this.getConnectionDetailsFromClientOptions(msgCtx);
            connectionFactory = this.defaultConnectionFactory;
        }
        XMPPSender xMPPSender = this;
        synchronized (xMPPSender) {
            xmppConnection = connectionFactory.getXmppConnection();
            if (xmppConnection == null) {
                connectionFactory.connect(this.serverCredentials);
                xmppConnection = connectionFactory.getXmppConnection();
            }
        }
        Message message = new Message();
        Options options = msgCtx.getOptions();
        String serviceName = XMPPUtils.getServiceName(targetAddress);
        SOAPVersion version = msgCtx.getEnvelope().getVersion();
        if (version instanceof SOAP12Version) {
            message.setProperty("ContentType", (Object)("application/soap+xml; action=" + msgCtx.getSoapAction()));
        } else {
            message.setProperty("ContentType", (Object)"text/xml");
        }
        if (targetAddress != null) {
            xmppOutTransportInfo = new XMPPOutTransportInfo(targetAddress);
            xmppOutTransportInfo.setConnectionFactory(this.defaultConnectionFactory);
        } else if ((msgCtx.getTo() == null || msgCtx.getTo().hasAnonymousAddress()) && msgCtx.isServerSide()) {
            xmppOutTransportInfo = (XMPPOutTransportInfo)msgCtx.getProperty("OutTransportInfo");
        }
        try {
            SOAPBody soapBodyEle;
            OMElement responseEle;
            if (msgCtx.isServerSide()) {
                message.setProperty("isServerSide", (Object)new Boolean(false));
                message.setProperty("inReplyTo", (Object)xmppOutTransportInfo.getInReplyTo());
                message.setProperty("transport.xmpp.sequenceID", (Object)xmppOutTransportInfo.getSequenceID());
            } else {
                AxisOperation axisOperation;
                message.setProperty("isServerSide", (Object)new Boolean(true));
                message.setProperty("transport.xmpp.containsSOAPEnvelope", (Object)new Boolean(true));
                message.setProperty("ServiceName", (Object)serviceName);
                String action = options.getAction();
                if (action == null && (axisOperation = msgCtx.getAxisOperation()) != null) {
                    action = axisOperation.getSoapAction();
                }
                if (action != null) {
                    message.setProperty("Action", (Object)action);
                }
            }
            if (xmppConnection == null) {
                XMPPSender.handleException("Connection to XMPP Server is not established.");
            }
            ChatManager chatManager = xmppConnection.getChatManager();
            Chat chat = chatManager.createChat(xmppOutTransportInfo.getDestinationAccount(), null);
            boolean waitForResponse = msgCtx.getOperationContext() != null && "http://www.w3.org/ns/wsdl/out-in".equals(msgCtx.getOperationContext().getAxisOperation().getMessageExchangePattern());
            String messageToBeSent = "";
            Object msgElement = "xmpp/text".equals(xmppOutTransportInfo.getContentType()) ? ((responseEle = (soapBodyEle = msgCtx.getEnvelope().getBody()).getFirstElement()) != null ? responseEle.getFirstElement() : responseEle) : msgCtx.getEnvelope();
            messageToBeSent = msgElement.toString();
            message.setBody(messageToBeSent);
            String key = null;
            if (waitForResponse && !msgCtx.isServerSide()) {
                PacketTypeFilter filter = new PacketTypeFilter(message.getClass());
                xmppConnection.addPacketListener((PacketListener)this.xmppClientSidePacketListener, (PacketFilter)filter);
                key = UUID.randomUUID().toString();
                this.xmppClientSidePacketListener.listenForResponse(key, msgCtx);
                message.setProperty("transport.xmpp.sequenceID", (Object)key);
            }
            chat.sendMessage(message);
            log.debug((Object)("Sent message :" + message.toXML()));
            if (waitForResponse && !msgCtx.isServerSide()) {
                this.xmppClientSidePacketListener.waitFor(key);
                log.debug((Object)"Received response sucessfully");
            }
        }
        catch (XMPPException e) {
            log.error((Object)("Error occurred while sending the message : " + message.toXML()), (Throwable)e);
            XMPPSender.handleException("Error occurred while sending the message : " + message.toXML(), (Exception)((Object)e));
        }
        catch (InterruptedException e) {
            log.error((Object)("Error occurred while sending the message : " + message.toXML()), (Throwable)e);
            XMPPSender.handleException("Error occurred while sending the message : " + message.toXML(), e);
        }
    }

    public static void processChatMessage(MessageContext msgCtx) throws AxisFault {
        Object obj = msgCtx.getProperty("transport.xmpp.message.from.chat");
        if (obj != null) {
            String message = (String)obj;
            String response = "";
            if (message.trim().startsWith("help")) {
                response = XMPPSender.prepareHelpTextForChat();
            } else if (message.trim().startsWith("listServices")) {
                response = XMPPSender.prepareServicesList(msgCtx);
            } else if (message.trim().startsWith("getOperations")) {
                response = XMPPSender.prepareOperationList(msgCtx, message);
            }
            XMPPSender.sendChatMessage(msgCtx, response);
        }
    }

    private static String prepareOperationList(MessageContext msgCtx, String chatMessage) {
        StringBuffer sb = new StringBuffer();
        String serviceName = chatMessage.replace("getOperations", "");
        serviceName = serviceName.replaceAll(" ", "");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finding operations for service :" + serviceName));
        }
        try {
            AxisService service = msgCtx.getConfigurationContext().getAxisConfiguration().getService(serviceName);
            Iterator itrOperations = service.getOperations();
            int index = 1;
            while (itrOperations.hasNext()) {
                AxisOperation operation = (AxisOperation)itrOperations.next();
                String parameterList = XMPPSender.getParameterListForOperation(operation);
                sb.append(index + "." + operation.getName().getLocalPart() + "(" + parameterList + ")\n");
                ++index;
            }
        }
        catch (AxisFault e) {
            log.error((Object)("Error occurred while retreiving AxisService : " + serviceName), (Throwable)e);
            sb.append("Error occurred while retrieving operations for service : " + serviceName);
        }
        return sb.toString();
    }

    private static String getParameterListForOperation(AxisOperation operation) {
        XmlSchemaComplexType complexType;
        XmlSchemaParticle particle;
        XmlSchemaType schemaType;
        StringBuffer paramList = new StringBuffer();
        AxisMessage axisMessage = operation.getMessage("In");
        XmlSchemaElement xmlSchemaElement = axisMessage.getSchemaElement();
        if (xmlSchemaElement != null && (schemaType = xmlSchemaElement.getSchemaType()) instanceof XmlSchemaComplexType && ((particle = (complexType = (XmlSchemaComplexType)schemaType).getParticle()) instanceof XmlSchemaSequence || particle instanceof XmlSchemaAll)) {
            if (particle instanceof XmlSchemaSequence) {
                XmlSchemaSequenceMember member;
                XmlSchemaElement innerElement;
                QName qName;
                XmlSchemaSequence sequence = (XmlSchemaSequence)particle;
                Iterator iterator = sequence.getItems().iterator();
                while (iterator.hasNext() && ((qName = (innerElement = (XmlSchemaElement)(member = (XmlSchemaSequenceMember)iterator.next())).getQName()) != null || !innerElement.getSchemaTypeName().equals(Constants.XSD_ANYTYPE))) {
                    String name = qName != null ? qName.getLocalPart() : innerElement.getName();
                    String type = innerElement.getSchemaTypeName().toString();
                    paramList.append("," + type + " " + name);
                }
            } else {
                XmlSchemaAllMember member;
                XmlSchemaElement innerElement;
                QName qName;
                XmlSchemaAll xmlSchemaAll = (XmlSchemaAll)particle;
                Iterator iterator = xmlSchemaAll.getItems().iterator();
                while (iterator.hasNext() && ((qName = (innerElement = (XmlSchemaElement)(member = (XmlSchemaAllMember)iterator.next())).getQName()) != null || !innerElement.getSchemaTypeName().equals(Constants.XSD_ANYTYPE))) {
                    String name = qName != null ? qName.getLocalPart() : innerElement.getName();
                    String type = innerElement.getSchemaTypeName().toString();
                    paramList.append("," + type + " " + name);
                }
            }
        }
        String list = paramList.toString();
        return list.replaceFirst(",", "");
    }

    private static String prepareServicesList(MessageContext msgCtx) {
        HashMap services = msgCtx.getConfigurationContext().getAxisConfiguration().getServices();
        StringBuffer sb = new StringBuffer();
        if (services != null && services.size() > 0) {
            Iterator itrServiceNames = services.keySet().iterator();
            int index = 1;
            while (itrServiceNames.hasNext()) {
                String serviceName = (String)itrServiceNames.next();
                sb.append(index + "." + serviceName + "\n");
                ++index;
            }
        }
        return sb.toString();
    }

    private static String prepareHelpTextForChat() {
        StringBuffer helpText = new StringBuffer();
        helpText.append("Following commands are supported :\n");
        helpText.append("-----------------------------------\n");
        helpText.append("1. listServices\n");
        helpText.append("2. getOperations <service-name>\n");
        helpText.append("3. call <service-name>:<operation>(<param1>,<param2>,...)\n");
        return helpText.toString();
    }

    private static void sendChatMessage(MessageContext msgCtx, String responseMsg) throws AxisFault {
        XMPPConnection xmppConnection = null;
        XMPPOutTransportInfo xmppOutTransportInfo = null;
        Message message = new Message();
        xmppOutTransportInfo = (XMPPOutTransportInfo)msgCtx.getProperty("OutTransportInfo");
        if (xmppOutTransportInfo != null) {
            message.setProperty("inReplyTo", (Object)xmppOutTransportInfo.getInReplyTo());
            xmppConnection = xmppOutTransportInfo.getConnectionFactory().getXmppConnection();
            if (xmppConnection == null) {
                XMPPSender.handleException("Connection to XMPP Server is not established.");
            }
        } else {
            XMPPSender.handleException("Could not find message sender details.");
        }
        ChatManager chatManager = xmppConnection.getChatManager();
        Chat chat = chatManager.createChat(xmppOutTransportInfo.getDestinationAccount(), null);
        try {
            message.setProperty("transport.xmpp.sequenceID", (Object)xmppOutTransportInfo.getSequenceID());
            message.setBody(responseMsg);
            chat.sendMessage(message);
            log.debug((Object)("Sent message :" + message.toXML()));
        }
        catch (XMPPException e) {
            XMPPSender.handleException("Error occurred while sending the message : " + message.toXML(), (Exception)((Object)e));
        }
    }

    private void getConnectionDetailsFromAxisConfiguration(TransportOutDescription transportOut) {
        if (transportOut != null) {
            Parameter serverType;
            Parameter password;
            Parameter userName;
            Parameter serverUrl = transportOut.getParameter("transport.xmpp.ServerUrl");
            if (serverUrl != null) {
                this.serverCredentials.setServerUrl(Utils.getParameterValue((Parameter)serverUrl));
            }
            if ((userName = transportOut.getParameter("transport.xmpp.ServerAccountUserName")) != null) {
                this.serverCredentials.setAccountName(Utils.getParameterValue((Parameter)userName));
            }
            if ((password = transportOut.getParameter("transport.xmpp.ServerAccountPassword")) != null) {
                this.serverCredentials.setPassword(Utils.getParameterValue((Parameter)password));
            }
            if ((serverType = transportOut.getParameter("transport.xmpp.ServerType")) != null) {
                this.serverCredentials.setServerType(Utils.getParameterValue((Parameter)serverType));
            }
            Parameter domainName = transportOut.getParameter("transport.xmpp.domain");
            if (serverUrl != null) {
                this.serverCredentials.setDomainName(Utils.getParameterValue((Parameter)domainName));
            }
        }
    }

    private void getConnectionDetailsFromClientOptions(MessageContext msgContext) {
        Options clientOptions = msgContext.getOptions();
        if (clientOptions.getProperty("transport.xmpp.ServerAccountUserName") != null) {
            this.serverCredentials.setAccountName((String)clientOptions.getProperty("transport.xmpp.ServerAccountUserName"));
        }
        if (clientOptions.getProperty("transport.xmpp.ServerAccountPassword") != null) {
            this.serverCredentials.setPassword((String)clientOptions.getProperty("transport.xmpp.ServerAccountPassword"));
        }
        if (clientOptions.getProperty("transport.xmpp.ServerUrl") != null) {
            this.serverCredentials.setServerUrl((String)clientOptions.getProperty("transport.xmpp.ServerUrl"));
        }
        if (clientOptions.getProperty("transport.xmpp.ServerType") != null) {
            this.serverCredentials.setServerType((String)clientOptions.getProperty("transport.xmpp.ServerType"));
        }
    }

    private static void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private static void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

