/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom.impl.mixin;

import org.apache.axiom.dom.DOMDocument;
import org.apache.axiom.dom.DOMDocumentType;
import org.apache.axiom.dom.DOMNodeFactory;
import org.apache.axiom.weaver.annotation.Mixin;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

@Mixin
public abstract class DOMImplementationMixin
implements DOMNodeFactory {
    @Override
    public boolean hasFeature(String feature, String version) {
        boolean anyVersion = version == null || version.length() == 0;
        return !(!feature.equalsIgnoreCase("Core") && !feature.equalsIgnoreCase("XML") || !anyVersion && !version.equals("1.0") && !version.equals("2.0") && !version.equals("3.0"));
    }

    @Override
    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        DOMDocument doc = this.createDocument();
        Element element = doc.createElementNS(namespaceURI, qualifiedName);
        doc.appendChild(element);
        return doc;
    }

    @Override
    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        DOMDocumentType docType = this.createDocumentTypeDeclaration();
        docType.coreSetRootName(qualifiedName);
        docType.coreSetPublicId(publicId);
        docType.coreSetSystemId(systemId);
        return docType;
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("TODO");
    }
}

