/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.box.internal;

import java.lang.reflect.Method;
import java.util.List;

import org.apache.camel.component.box.api.BoxCollaborationsManager;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;
import static org.apache.camel.support.component.ApiMethodArg.setter;

/**
 * Camel {@link ApiMethod} Enumeration for org.apache.camel.component.box.api.BoxCollaborationsManager
 */
public enum BoxCollaborationsManagerApiMethod implements ApiMethod {

    ADD_FOLDER_COLLABORATION(
        com.box.sdk.BoxCollaboration.class,
        "addFolderCollaboration",
        arg("folderId", String.class),
        arg("collaborator", com.box.sdk.BoxCollaborator.class),
        arg("role", com.box.sdk.BoxCollaboration.Role.class)),

    ADD_FOLDER_COLLABORATION_BY_EMAIL(
        com.box.sdk.BoxCollaboration.class,
        "addFolderCollaborationByEmail",
        arg("folderId", String.class),
        arg("email", String.class),
        arg("role", com.box.sdk.BoxCollaboration.Role.class)),

    DELETE_COLLABORATION(
        void.class,
        "deleteCollaboration",
        arg("collaborationId", String.class)),

    GET_COLLABORATION_INFO(
        com.box.sdk.BoxCollaboration.Info.class,
        "getCollaborationInfo",
        arg("collaborationId", String.class)),

    GET_FOLDER_COLLABORATIONS(
        java.util.Collection.class,
        "getFolderCollaborations",
        arg("folderId", String.class)),

    GET_PENDING_COLLABORATIONS(
        java.util.Collection.class,
        "getPendingCollaborations"),

    UPDATE_COLLABORATION_INFO(
        com.box.sdk.BoxCollaboration.class,
        "updateCollaborationInfo",
        arg("collaborationId", String.class),
        arg("info", com.box.sdk.BoxCollaboration.Info.class));

    private final ApiMethod apiMethod;

    BoxCollaborationsManagerApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(BoxCollaborationsManager.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<String> getSetterArgNames() { return apiMethod.getSetterArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
