/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration.builders;

import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.matchers.FullTextMatcher;
import org.apache.rat.analysis.matchers.SimpleTextMatcher;
import org.apache.rat.config.parameters.MatcherBuilder;
import org.apache.rat.configuration.builders.AbstractBuilder;

@MatcherBuilder(value=SimpleTextMatcher.class)
public class TextBuilder
extends AbstractBuilder {
    private static final int MAX_DISPLAY_LENGTH = 20;
    private String text;

    public TextBuilder setSimpleText(String text) {
        this.text = text.trim();
        if (StringUtils.isBlank(text)) {
            throw new ConfigurationException("'text' may not be empty");
        }
        return this;
    }

    @Override
    public SimpleTextMatcher build() {
        if (StringUtils.isBlank(this.text)) {
            throw new ConfigurationException("text value is required");
        }
        boolean complex = this.text.contains(" ") | this.text.contains("\\t") | this.text.contains("\\n") | this.text.contains("\\r") | this.text.contains("\\f") | this.text.contains("\\v");
        return complex ? new FullTextMatcher(this.getId(), this.text) : new SimpleTextMatcher(this.getId(), this.text);
    }

    @Override
    public String toString() {
        if (this.text.length() > 20) {
            return "TextBuilder: " + this.text.substring(0, 20) + "...";
        }
        return "TextBuilder: " + this.text;
    }
}

