/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHeapItemsSketch;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIterator;
import org.apache.datasketches.quantilescommon.QuantilesFloatsSketchIterator;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllCrossLanguageTest {
    private ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();

    @Test(groups={"generate_java_files"})
    public void generateKllDoublesSketchBinaries() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
            for (int i = 1; i <= n; ++i) {
                sk.update((double)i);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("kll_double_n" + n + "_java.sk"), new OpenOption[0]).write(sk.toByteArray());
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateKllFloatsSketchBinaries() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
            for (int i = 1; i <= n; ++i) {
                sk.update((float)i);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("kll_float_n" + n + "_java.sk"), new OpenOption[0]).write(sk.toByteArray());
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateKllLongsSketchBinaries() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            KllLongsSketch sk = KllLongsSketch.newHeapInstance();
            for (int i = 1; i <= n; ++i) {
                sk.update((long)i);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("kll_long_n" + n + "_java.sk"), new OpenOption[0]).write(sk.toByteArray());
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateKllItemsSketchBinaries() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            int digits = Util.numDigits((long)n);
            KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
            for (int i = 1; i <= n; ++i) {
                sk.update((Object)Util.longToFixedLengthString((long)i, (int)digits));
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("kll_string_n" + n + "_java.sk"), new OpenOption[0]).write(sk.toByteArray());
        }
    }

    @Test(groups={"check_cpp_historical_files"})
    public void checkCppKllDoublesSketchOneItemVersion1() {
        byte[] byteArr = TestUtil.getResourceBytes("kll_sketch_double_one_item_v1.sk");
        KllDoublesSketch sk = KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])byteArr));
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
    }

    @Test(groups={"check_cpp_historical_files"})
    public void checkCppKllFloatsSketchOneItemVersion1() {
        byte[] byteArr = TestUtil.getResourceBytes("kll_sketch_float_one_item_v1.sk");
        KllFloatsSketch sk = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])byteArr));
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sk.getMaxItem(), (float)1.0f);
    }

    @Test(groups={"check_cpp_files"})
    public void kllFloat() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("kll_float_n" + n + "_cpp.sk"));
            KllFloatsSketch sketch = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
            Assert.assertEquals((int)sketch.getK(), (int)200);
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertTrue((boolean)(n > 100 ? sketch.isEstimationMode() : !sketch.isEstimationMode()));
            Assert.assertEquals((long)sketch.getN(), (long)n);
            if (n <= 0) continue;
            Assert.assertEquals((float)sketch.getMinItem(), (float)1.0f);
            Assert.assertEquals((float)sketch.getMaxItem(), (float)n);
            long weight = 0L;
            QuantilesFloatsSketchIterator it = sketch.iterator();
            while (it.next()) {
                Assert.assertTrue((it.getQuantile() >= sketch.getMinItem() ? 1 : 0) != 0);
                Assert.assertTrue((it.getQuantile() <= sketch.getMaxItem() ? 1 : 0) != 0);
                weight += it.getWeight();
            }
            Assert.assertEquals((long)weight, (long)n);
        }
    }

    @Test(groups={"check_cpp_files"})
    public void kllDouble() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("kll_double_n" + n + "_cpp.sk"));
            KllDoublesSketch sketch = KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])bytes));
            Assert.assertEquals((int)sketch.getK(), (int)200);
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertTrue((boolean)(n > 100 ? sketch.isEstimationMode() : !sketch.isEstimationMode()));
            Assert.assertEquals((long)sketch.getN(), (long)n);
            if (n <= 0) continue;
            Assert.assertEquals((double)sketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)sketch.getMaxItem(), (double)n);
            long weight = 0L;
            QuantilesDoublesSketchIterator it = sketch.iterator();
            while (it.next()) {
                Assert.assertTrue((it.getQuantile() >= sketch.getMinItem() ? 1 : 0) != 0);
                Assert.assertTrue((it.getQuantile() <= sketch.getMaxItem() ? 1 : 0) != 0);
                weight += it.getWeight();
            }
            Assert.assertEquals((long)weight, (long)n);
        }
    }

    @Test(groups={"check_cpp_files"})
    public void kllString() throws IOException {
        int[] nArr;
        Comparator<String> numericOrder = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                try {
                    int i1 = Integer.parseInt(s1);
                    int i2 = Integer.parseInt(s2);
                    return Integer.compare(i1, i2);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        for (int n : nArr = new int[]{0, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("kll_string_n" + n + "_cpp.sk"));
            KllHeapItemsSketch sketch = new KllHeapItemsSketch(Memory.wrap((byte[])bytes), (Comparator)numericOrder, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
            Assert.assertEquals((int)sketch.getK(), (int)200);
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertTrue((boolean)(n > 100 ? sketch.isEstimationMode() : !sketch.isEstimationMode()));
            Assert.assertEquals((long)sketch.getN(), (long)n);
            if (n <= 0) continue;
            Assert.assertEquals((String)((String)sketch.getMinItem()), (String)Integer.toString(1));
            Assert.assertEquals((String)((String)sketch.getMaxItem()), (String)Integer.toString(n));
            long weight = 0L;
            QuantilesGenericSketchIterator it = sketch.iterator();
            while (it.next()) {
                Assert.assertTrue((numericOrder.compare((String)it.getQuantile(), (String)sketch.getMinItem()) >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((numericOrder.compare((String)it.getQuantile(), (String)sketch.getMaxItem()) <= 0 ? 1 : 0) != 0);
                weight += it.getWeight();
            }
            Assert.assertEquals((long)weight, (long)n);
        }
    }
}

