/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.thetacommon;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.thetacommon.BoundsOnRatiosInThetaSketchedSets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BoundsOnRatiosInThetaSketchedSetsTest {
    @Test
    public void checkNormalReturns() {
        int i;
        UpdateSketch skA = Sketches.updateSketchBuilder().build();
        UpdateSketch skC = Sketches.updateSketchBuilder().build();
        int uA = 10000;
        int uC = 100000;
        for (i = 0; i < 10000; ++i) {
            skA.update((long)i);
        }
        for (i = 0; i < 100000; ++i) {
            skC.update((long)(i + 5000));
        }
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        inter.intersect((Sketch)skA);
        inter.intersect((Sketch)skC);
        CompactSketch skB = inter.getResult();
        double est = BoundsOnRatiosInThetaSketchedSets.getEstimateOfBoverA((Sketch)skA, (Sketch)skB);
        double lb = BoundsOnRatiosInThetaSketchedSets.getLowerBoundForBoverA((Sketch)skA, (Sketch)skB);
        double ub = BoundsOnRatiosInThetaSketchedSets.getUpperBoundForBoverA((Sketch)skA, (Sketch)skB);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        Assert.assertTrue((est > lb ? 1 : 0) != 0);
        Assert.assertEquals((double)est, (double)0.5, (double)0.03);
        BoundsOnRatiosInThetaSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInThetaSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInThetaSketchedSetsTest.println("lb : " + lb);
        skA.reset();
        est = BoundsOnRatiosInThetaSketchedSets.getEstimateOfBoverA((Sketch)skA, (Sketch)skB);
        lb = BoundsOnRatiosInThetaSketchedSets.getLowerBoundForBoverA((Sketch)skA, (Sketch)skB);
        ub = BoundsOnRatiosInThetaSketchedSets.getUpperBoundForBoverA((Sketch)skA, (Sketch)skB);
        BoundsOnRatiosInThetaSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInThetaSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInThetaSketchedSetsTest.println("lb : " + lb);
        skC.reset();
        est = BoundsOnRatiosInThetaSketchedSets.getEstimateOfBoverA((Sketch)skA, (Sketch)skC);
        lb = BoundsOnRatiosInThetaSketchedSets.getLowerBoundForBoverA((Sketch)skA, (Sketch)skC);
        ub = BoundsOnRatiosInThetaSketchedSets.getUpperBoundForBoverA((Sketch)skA, (Sketch)skC);
        BoundsOnRatiosInThetaSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInThetaSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInThetaSketchedSetsTest.println("lb : " + lb);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAbnormalReturns() {
        int i;
        UpdateSketch skA = Sketches.updateSketchBuilder().build();
        UpdateSketch skC = Sketches.updateSketchBuilder().build();
        int uA = 100000;
        int uC = 10000;
        for (i = 0; i < 100000; ++i) {
            skA.update((long)i);
        }
        for (i = 0; i < 10000; ++i) {
            skC.update((long)(i + 50000));
        }
        BoundsOnRatiosInThetaSketchedSets.getEstimateOfBoverA((Sketch)skA, (Sketch)skC);
    }

    @Test
    public void printlnTest() {
        BoundsOnRatiosInThetaSketchedSetsTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

