/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Objects;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.quantiles.QuantilesItemsSketch;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIteratorAPI;

public final class QuantilesItemsSketchIterator<T>
implements QuantilesGenericSketchIteratorAPI<T> {
    private Object[] combinedBuffer;
    private long bitPattern;
    private int level;
    private long weight;
    private int index;
    private int offset;
    private int num;
    private int k;

    QuantilesItemsSketchIterator(QuantilesItemsSketch<T> sketch, long bitPattern) {
        Objects.requireNonNull(sketch, "sketch must not be null");
        this.combinedBuffer = sketch.combinedBuffer_;
        this.num = sketch.getBaseBufferCount();
        this.k = sketch.getK();
        this.bitPattern = bitPattern;
        this.level = -1;
        this.weight = 1L;
        this.index = -1;
        this.offset = 0;
    }

    @Override
    public T getQuantile() {
        if (this.index < 0) {
            throw new SketchesStateException("index < 0; getQuantile() was called before next()");
        }
        return (T)this.combinedBuffer[this.offset + this.index];
    }

    @Override
    public long getWeight() {
        return this.weight;
    }

    @Override
    public boolean next() {
        ++this.index;
        if (this.index < this.num) {
            return true;
        }
        do {
            ++this.level;
            if (this.level > 0) {
                this.bitPattern >>>= 1;
            }
            if (this.bitPattern == 0L) {
                return false;
            }
            this.weight *= 2L;
        } while ((this.bitPattern & 1L) == 0L);
        this.index = 0;
        this.offset = (2 + this.level) * this.k;
        this.num = this.k;
        return true;
    }
}

