/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.DirectArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.HeapArrayOfDoublesSketchIterator;

final class HeapArrayOfDoublesCompactSketch
extends ArrayOfDoublesCompactSketch {
    private final short seedHash_;
    private long[] keys_;
    private double[] values_;

    HeapArrayOfDoublesCompactSketch(ArrayOfDoublesUpdatableSketch sketch) {
        this(sketch, sketch.getThetaLong());
    }

    HeapArrayOfDoublesCompactSketch(ArrayOfDoublesUpdatableSketch sketch, long thetaLong) {
        super(sketch.getNumValues());
        this.isEmpty_ = sketch.isEmpty();
        this.thetaLong_ = Math.min(sketch.getThetaLong(), thetaLong);
        this.seedHash_ = Util.computeSeedHash(sketch.getSeed());
        int count = sketch.getRetainedEntries();
        if (count > 0) {
            this.keys_ = new long[count];
            this.values_ = new double[count * this.numValues_];
            ArrayOfDoublesSketchIterator it = sketch.iterator();
            int i = 0;
            while (it.next()) {
                long key = it.getKey();
                if (key >= this.thetaLong_) continue;
                this.keys_[i] = key;
                System.arraycopy(it.getValues(), 0, this.values_, i * this.numValues_, this.numValues_);
                ++i;
            }
            if (i < count) {
                if (i == 0) {
                    this.keys_ = null;
                    this.values_ = null;
                } else {
                    this.keys_ = Arrays.copyOf(this.keys_, i);
                    this.values_ = Arrays.copyOf(this.values_, i * this.numValues_);
                }
            }
        }
    }

    HeapArrayOfDoublesCompactSketch(long[] keys, double[] values, long thetaLong, boolean isEmpty, int numValues, short seedHash) {
        super(numValues);
        this.keys_ = keys;
        this.values_ = values;
        this.thetaLong_ = thetaLong;
        this.isEmpty_ = isEmpty;
        this.seedHash_ = seedHash;
    }

    HeapArrayOfDoublesCompactSketch(MemorySegment seg) {
        this(seg, 9001L);
    }

    HeapArrayOfDoublesCompactSketch(MemorySegment seg, long seed) {
        super(seg.get(ValueLayout.JAVA_BYTE, 5L));
        boolean hasEntries;
        this.seedHash_ = seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, 6L);
        SerializerDeserializer.validateFamily(seg.get(ValueLayout.JAVA_BYTE, 2L), seg.get(ValueLayout.JAVA_BYTE, 0L));
        SerializerDeserializer.validateType(seg.get(ValueLayout.JAVA_BYTE, 3L), SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch);
        byte version = seg.get(ValueLayout.JAVA_BYTE, 1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        Util.checkSeedHashes(this.seedHash_, Util.computeSeedHash(seed));
        this.isEmpty_ = (seg.get(ValueLayout.JAVA_BYTE, 4L) & 1 << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal()) != 0;
        this.thetaLong_ = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
        boolean bl = hasEntries = (seg.get(ValueLayout.JAVA_BYTE, 4L) & 1 << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()) != 0;
        if (hasEntries) {
            int count = seg.get(ValueLayout.JAVA_INT_UNALIGNED, 16L);
            this.keys_ = new long[count];
            this.values_ = new double[count * this.numValues_];
            MemorySegment.copy(seg, ValueLayout.JAVA_LONG_UNALIGNED, 24L, this.keys_, 0, count);
            MemorySegment.copy(seg, ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L + 8L * (long)count, this.values_, 0, this.values_.length);
        }
    }

    @Override
    public ArrayOfDoublesCompactSketch compact(MemorySegment dstSeg) {
        if (dstSeg == null) {
            return new HeapArrayOfDoublesCompactSketch((long[])this.keys_.clone(), (double[])this.values_.clone(), this.thetaLong_, this.isEmpty_, this.numValues_, this.seedHash_);
        }
        byte[] byteArr = this.toByteArray();
        MemorySegment.copy(byteArr, 0, dstSeg, ValueLayout.JAVA_BYTE, 0L, byteArr.length);
        return new DirectArrayOfDoublesCompactSketch(dstSeg);
    }

    @Override
    public int getRetainedEntries() {
        return this.keys_ == null ? 0 : this.keys_.length;
    }

    @Override
    public byte[] toByteArray() {
        int count = this.getRetainedEntries();
        int sizeBytes = this.getCurrentBytes();
        byte[] bytes = new byte[sizeBytes];
        MemorySegment seg = MemorySegment.ofArray(bytes);
        seg.set(ValueLayout.JAVA_BYTE, 0L, (byte)1);
        seg.set(ValueLayout.JAVA_BYTE, 1L, (byte)1);
        seg.set(ValueLayout.JAVA_BYTE, 2L, (byte)Family.TUPLE.getID());
        seg.set(ValueLayout.JAVA_BYTE, 3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesCompactSketch.ordinal());
        seg.set(ValueLayout.JAVA_BYTE, 4L, (byte)((this.isEmpty() ? 1 : 0) << ArrayOfDoublesSketch.Flags.IS_EMPTY.ordinal() | (count > 0 ? 1 : 0) << ArrayOfDoublesSketch.Flags.HAS_ENTRIES.ordinal()));
        seg.set(ValueLayout.JAVA_BYTE, 5L, (byte)this.numValues_);
        seg.set(ValueLayout.JAVA_SHORT_UNALIGNED, 6L, this.seedHash_);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 8L, this.thetaLong_);
        if (count > 0) {
            seg.set(ValueLayout.JAVA_INT_UNALIGNED, 16L, count);
            MemorySegment.copy(this.keys_, 0, seg, ValueLayout.JAVA_LONG_UNALIGNED, 24L, count);
            MemorySegment.copy(this.values_, 0, seg, ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L + 8L * (long)count, this.values_.length);
        }
        return bytes;
    }

    @Override
    public double[][] getValues() {
        int count = this.getRetainedEntries();
        double[][] values = new double[count][];
        if (count > 0) {
            int i = 0;
            for (int j = 0; j < count; ++j) {
                values[i++] = Arrays.copyOfRange(this.values_, j * this.numValues_, (j + 1) * this.numValues_);
            }
        }
        return values;
    }

    @Override
    double[] getValuesAsOneDimension() {
        return (double[])this.values_.clone();
    }

    @Override
    long[] getKeys() {
        return (long[])this.keys_.clone();
    }

    @Override
    public ArrayOfDoublesSketchIterator iterator() {
        return new HeapArrayOfDoublesSketchIterator(this.keys_, this.values_, this.numValues_);
    }

    @Override
    short getSeedHash() {
        return this.seedHash_;
    }

    @Override
    public boolean hasMemorySegment() {
        return false;
    }

    @Override
    MemorySegment getMemorySegment() {
        return null;
    }
}

