/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequest;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

public class DeleteRequestDecorator
extends SingleReplyRequestDecorator<DeleteRequest>
implements DeleteRequest {
    private byte[] dnBytes;

    public DeleteRequestDecorator(LdapApiService codec, DeleteRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public Dn getName() {
        return ((DeleteRequest)this.getDecorated()).getName();
    }

    public DeleteRequest setName(Dn name) {
        ((DeleteRequest)this.getDecorated()).setName(name);
        return this;
    }

    public DeleteRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public DeleteRequest addControl(Control control) {
        return (DeleteRequest)super.addControl(control);
    }

    public DeleteRequest addAllControls(Control[] controls) {
        return (DeleteRequest)super.addAllControls(controls);
    }

    public DeleteRequest removeControl(Control control) {
        return (DeleteRequest)super.removeControl(control);
    }

    @Override
    public int computeLength() {
        this.dnBytes = Strings.getBytesUtf8((String)this.getName().getName());
        int dnLength = this.dnBytes.length;
        return 1 + TLV.getNbBytes((int)dnLength) + dnLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)74);
            buffer.put(TLV.getBytes((int)this.dnBytes.length));
            buffer.put(this.dnBytes);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]), (Exception)boe);
        }
        return buffer;
    }
}

