/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.api.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.api.ldap.model.message.DeleteResponse;

public class DeleteResponseDecorator
extends ResponseDecorator<DeleteResponse>
implements DeleteResponse {
    private int deleteResponseLength;

    public DeleteResponseDecorator(LdapApiService codec, DeleteResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    @Override
    public int computeLength() {
        this.deleteResponseLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        return 1 + TLV.getNbBytes(this.deleteResponseLength) + this.deleteResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)107);
            buffer.put(TLV.getBytes(this.deleteResponseLength));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]), boe);
        }
        return buffer;
    }
}

