/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.admin.management.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.openmbean.TabularData;
import org.apache.felix.karaf.admin.AdminService;
import org.apache.felix.karaf.admin.Instance;
import org.apache.felix.karaf.admin.InstanceSettings;
import org.apache.felix.karaf.admin.management.AdminServiceMBean;
import org.apache.felix.karaf.admin.management.codec.JmxInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminServiceMBeanImpl
implements AdminServiceMBean {
    private AdminService adminService;

    public AdminService getAdminService() {
        return this.adminService;
    }

    public void setAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    @Override
    public int createInstance(String name, int port, String location, String features, String featureURLs) throws Exception {
        InstanceSettings settings;
        Instance inst;
        if ("".equals(location)) {
            location = null;
        }
        if ((inst = this.adminService.createInstance(name, settings = new InstanceSettings(port, location, this.parseStringList(featureURLs), this.parseStringList(features)))) != null) {
            return inst.getPid();
        }
        return -1;
    }

    @Override
    public void changePort(String name, int port) throws Exception {
        this.getExistingInstance(name).changePort(port);
    }

    @Override
    public void destroyInstance(String name) throws Exception {
        this.getExistingInstance(name).destroy();
    }

    @Override
    public void startInstance(String name, String opts) throws Exception {
        this.getExistingInstance(name).start(opts);
    }

    @Override
    public void stopInstance(String name) throws Exception {
        this.getExistingInstance(name).stop();
    }

    @Override
    public TabularData getInstances() throws Exception {
        List<Instance> allInstances = Arrays.asList(this.adminService.getInstances());
        ArrayList<JmxInstance> instances = new ArrayList<JmxInstance>();
        for (Instance instance : allInstances) {
            instances.add(new JmxInstance(instance));
        }
        TabularData table = JmxInstance.tableFrom(instances);
        return table;
    }

    private Instance getExistingInstance(String name) {
        Instance i = this.adminService.getInstance(name);
        if (i == null) {
            throw new IllegalArgumentException("Instance '" + name + "' does not exist");
        }
        return i;
    }

    private List<String> parseStringList(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            for (String el : value.split(",")) {
                String trimmed = el.trim();
                if (trimmed.length() == 0) continue;
                list.add(trimmed);
            }
        }
        return list;
    }
}

