/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.URLHandlers;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class URLHandlersActivator
implements BundleActivator {
    private final Map m_configMap;
    private final Felix m_framework;
    private volatile ServiceTracker m_streamTracker;
    private volatile ServiceTracker m_contentTracker;

    public URLHandlersActivator(Map configMap, Felix framework) {
        this.m_configMap = configMap;
        this.m_framework = framework;
    }

    public void start(BundleContext context) {
        boolean enable;
        boolean bl = this.m_configMap.get("felix.service.urlhandlers") == null ? true : (enable = !this.m_configMap.get("felix.service.urlhandlers").equals("false"));
        if (enable) {
            this.m_streamTracker = new ServiceTracker(context, "org.osgi.service.url.URLStreamHandlerService", null);
            this.m_contentTracker = new ServiceTracker(context, "java.net.ContentHandler", null);
            this.m_streamTracker.open();
            this.m_contentTracker.open();
            this.m_framework.setURLHandlersActivator(this);
        }
        URLHandlers.registerFrameworkInstance(this.m_framework, enable);
    }

    public void stop(BundleContext context) {
        URLHandlers.unregisterFrameworkInstance(this.m_framework);
        this.m_framework.setURLHandlersActivator(null);
        if (this.m_streamTracker != null) {
            this.m_streamTracker.close();
        }
        if (this.m_contentTracker != null) {
            this.m_contentTracker.close();
        }
        this.m_streamTracker = null;
        this.m_contentTracker = null;
    }

    protected Object getStreamHandlerService(String protocol) {
        return this.get(this.m_streamTracker, "url.handler.protocol", protocol);
    }

    protected Object getContentHandlerService(String mimeType) {
        return this.get(this.m_contentTracker, "url.content.mimetype", mimeType);
    }

    private Object get(ServiceTracker tracker, String key, String value) {
        ServiceReference[] refs;
        Object service = null;
        if (tracker != null && (refs = tracker.getServiceReferences()) != null) {
            if (refs.length > 1) {
                Arrays.sort(refs, Collections.reverseOrder());
            }
            for (int i = 0; i < refs.length && service == null; ++i) {
                Object values = refs[i].getProperty(key);
                if (values instanceof String[]) {
                    for (int j = 0; j < ((String[])values).length && service == null; ++j) {
                        if (!value.equals(((String[])values)[j])) continue;
                        service = tracker.getService(refs[i]);
                    }
                    continue;
                }
                if (!value.equals(values)) continue;
                service = tracker.getService(refs[i]);
            }
        }
        return service;
    }
}

