/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.searchpolicy;

import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import org.apache.felix.framework.searchpolicy.ResolvedPackage;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IRequirement;
import org.apache.felix.moduleloader.IWire;
import org.apache.felix.moduleloader.ResourceNotFoundException;

public class R4WireModule
implements IWire {
    private final IModule m_importer;
    private final IRequirement m_requirement;
    private final IModule m_exporter;
    private final ICapability m_capability;
    private final Map m_pkgMap;

    public R4WireModule(IModule importer, IRequirement requirement, IModule exporter, ICapability capability, Map pkgMap) {
        this.m_importer = importer;
        this.m_requirement = requirement;
        this.m_exporter = exporter;
        this.m_capability = capability;
        this.m_pkgMap = pkgMap;
    }

    public IModule getImporter() {
        return this.m_importer;
    }

    public IRequirement getRequirement() {
        return this.m_requirement;
    }

    public IModule getExporter() {
        return this.m_exporter;
    }

    public ICapability getCapability() {
        return this.m_capability;
    }

    public boolean hasPackage(String pkgName) {
        return this.m_pkgMap.get(pkgName) != null;
    }

    public Class getClass(String name) throws ClassNotFoundException {
        String pkgName = Util.getClassPackage(name);
        ResolvedPackage rp = (ResolvedPackage)this.m_pkgMap.get(pkgName);
        if (rp != null) {
            try {
                Class clazz = this.m_exporter.getClassByDelegation(name);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public URL getResource(String name) throws ResourceNotFoundException {
        URL url;
        String pkgName = Util.getResourcePackage(name);
        ResolvedPackage rp = (ResolvedPackage)this.m_pkgMap.get(pkgName);
        if (rp != null && (url = this.m_exporter.getResourceByDelegation(name)) != null) {
            return url;
        }
        return null;
    }

    public Enumeration getResources(String name) throws ResourceNotFoundException {
        Enumeration urls;
        String pkgName = Util.getResourcePackage(name);
        ResolvedPackage rp = (ResolvedPackage)this.m_pkgMap.get(pkgName);
        if (rp != null && (urls = this.m_exporter.getResourcesByDelegation(name)) != null) {
            return urls;
        }
        return null;
    }

    public String toString() {
        return this.m_importer + " -> " + this.m_capability + " -> " + this.m_exporter;
    }
}

