/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.internal.JclLogger;
import org.ops4j.pax.logging.OSGIPaxLoggingManager;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.internal.FallbackLogFactory;
import org.osgi.framework.BundleContext;

public class LogFactory {
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    private static LogFactory m_instance = new LogFactory();
    private static PaxLoggingManager m_paxLogging;
    private static Map m_loggers;

    public static void setBundleContext(BundleContext ctx) {
        m_paxLogging = new OSGIPaxLoggingManager(ctx);
        Set entrySet = m_loggers.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            JclLogger logger = (JclLogger)entry.getKey();
            String name = (String)entry.getValue();
            logger.setPaxLoggingManager(m_paxLogging, name);
        }
        m_paxLogging.open();
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return m_instance;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    public static void release(ClassLoader classLoader) {
    }

    public static void releaseAll() {
    }

    public Object getAttribute(String name) {
        return null;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String name) throws LogConfigurationException {
        PaxLogger logger = m_paxLogging == null ? FallbackLogFactory.createFallbackLog(null, name) : m_paxLogging.getLogger(name, JclLogger.JCL_FQCN);
        JclLogger jclLogger = new JclLogger(logger);
        m_loggers.put(jclLogger, name);
        return jclLogger;
    }

    public static void release() {
    }

    public void removeAttribute(String name) {
    }

    public void setAttribute(String name, Object value) {
    }

    public static void dispose() {
        m_paxLogging.close();
        m_paxLogging.dispose();
        m_paxLogging = null;
    }

    static {
        m_loggers = Collections.synchronizedMap(new WeakHashMap());
    }
}

