/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.admin.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.karaf.admin.Instance;
import org.apache.felix.karaf.admin.internal.AdminServiceImpl;
import org.apache.felix.karaf.jpm.Process;
import org.apache.felix.karaf.jpm.ProcessBuilderFactory;
import org.apache.felix.karaf.jpm.impl.ScriptUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceImpl
implements Instance {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceImpl.class);
    private static final String CONFIG_PROPERTIES_FILE_NAME = "config.properties";
    private static final String KARAF_SHUTDOWN_PORT = "karaf.shutdown.port";
    private static final String KARAF_SHUTDOWN_HOST = "karaf.shutdown.host";
    private static final String KARAF_SHUTDOWN_PORT_FILE = "karaf.shutdown.port.file";
    private static final String KARAF_SHUTDOWN_COMMAND = "karaf.shutdown.command";
    private static final String KARAF_SHUTDOWN_PID_FILE = "karaf.shutdown.pid.file";
    private static final String DEFAULT_SHUTDOWN_COMMAND = "SHUTDOWN";
    private AdminServiceImpl service;
    private String name;
    private String location;
    private Process process;
    private boolean root;
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public InstanceImpl(AdminServiceImpl service, String name, String location) {
        this(service, name, location, false);
    }

    public InstanceImpl(AdminServiceImpl service, String name, String location, boolean root) {
        this.service = service;
        this.name = name;
        this.location = location;
        this.root = root;
    }

    public void attach(int pid) throws IOException {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance already started");
        }
        this.process = ProcessBuilderFactory.newInstance().newBuilder().attach(pid);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public boolean exists() {
        return new File(this.location).isDirectory();
    }

    @Override
    public int getPid() {
        this.checkProcess();
        return this.process != null ? this.process.getPid() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPort() {
        InputStream is = null;
        try {
            File f = new File(this.location, "etc/org.apache.felix.karaf.shell.cfg");
            is = new FileInputStream(f);
            Properties props = new Properties();
            props.load(is);
            String loc = props.getProperty("sshPort");
            int n = Integer.parseInt(loc);
            return n;
        }
        catch (Exception e) {
            int n = 0;
            return n;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePort(int port) throws Exception {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance not stopped");
        }
        Properties props = new Properties();
        File f = new File(this.location, "etc/org.apache.felix.karaf.shell.cfg");
        FileInputStream is = new FileInputStream(f);
        try {
            props.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
        props.setProperty("sshPort", Integer.toString(port));
        FileOutputStream os = new FileOutputStream(f);
        try {
            props.store(os, null);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    @Override
    public synchronized void start(String javaOpts) throws Exception {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance already started");
        }
        if (javaOpts == null) {
            javaOpts = "-server -Xmx512M -Dcom.sun.management.jmxremote";
        }
        File libDir = new File(System.getProperty("karaf.home"), "lib");
        File[] jars = libDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        StringBuilder classpath = new StringBuilder();
        for (File jar : jars) {
            if (classpath.length() > 0) {
                classpath.append(System.getProperty("path.separator"));
            }
            classpath.append(jar.getCanonicalPath());
        }
        String command = new File(System.getProperty("java.home"), ScriptUtils.isWindows() ? "bin\\java.exe" : "bin/java").getCanonicalPath() + " " + javaOpts + " -Djava.util.logging.config.file=\"" + new File(this.location, "etc/java.util.logging.properties").getCanonicalPath() + "\"" + " -Djava.endorsed.dirs=\"" + new File(new File(System.getProperty("java.home"), "lib"), "endorsed") + System.getProperty("path.separator") + new File(libDir, "endorsed").getCanonicalPath() + "\"" + " -Djava.ext.dirs=\"" + new File(new File(System.getProperty("java.home"), "lib"), "ext") + System.getProperty("path.separator") + new File(libDir, "ext").getCanonicalPath() + "\"" + " -Dkaraf.home=\"" + System.getProperty("karaf.home") + "\"" + " -Dkaraf.base=\"" + new File(this.location).getCanonicalPath() + "\"" + " -Dkaraf.startLocalConsole=false" + " -Dkaraf.startRemoteShell=true" + " -classpath " + classpath.toString() + " org.apache.felix.karaf.main.Main";
        LOG.debug("Starting instance " + this.name + " with command: " + command);
        this.process = ProcessBuilderFactory.newInstance().newBuilder().directory(new File(this.location)).command(command).start();
        this.service.saveState();
    }

    @Override
    public synchronized void stop() throws Exception {
        this.checkProcess();
        if (this.process == null) {
            throw new IllegalStateException("Instance not started");
        }
        this.cleanShutdown();
        if (this.process != null) {
            this.process.destroy();
        }
    }

    @Override
    public synchronized void destroy() throws Exception {
        this.checkProcess();
        if (this.process != null) {
            throw new IllegalStateException("Instance not stopped");
        }
        InstanceImpl.deleteFile(new File(this.location));
        this.service.forget(this.name);
        this.service.saveState();
    }

    @Override
    public synchronized String getState() {
        int port = this.getPort();
        if (!this.exists() || port <= 0) {
            return "Error";
        }
        this.checkProcess();
        if (this.process == null) {
            return "Stopped";
        }
        try {
            Socket s = new Socket("localhost", port);
            s.close();
            return "Started";
        }
        catch (Exception exception) {
            return "Starting";
        }
    }

    protected void checkProcess() {
        if (this.process != null) {
            try {
                if (!this.process.isRunning()) {
                    this.process = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void cleanShutdown() {
        try {
            File file = new File(new File(this.location, "etc"), CONFIG_PROPERTIES_FILE_NAME);
            URL configPropURL = file.toURI().toURL();
            Properties props = InstanceImpl.loadPropertiesFile(configPropURL);
            props.put("karaf.base", new File(this.location).getCanonicalPath());
            props.put("karaf.home", System.getProperty("karaf.home"));
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                props.setProperty(name, InstanceImpl.substVars(props.getProperty(name), name, null, props));
            }
            int port = Integer.parseInt(props.getProperty(KARAF_SHUTDOWN_PORT, "0"));
            String host = props.getProperty(KARAF_SHUTDOWN_HOST, "localhost");
            String portFile = props.getProperty(KARAF_SHUTDOWN_PORT_FILE);
            String shutdown = props.getProperty(KARAF_SHUTDOWN_COMMAND, DEFAULT_SHUTDOWN_COMMAND);
            if (port == 0 && portFile != null) {
                BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(portFile)));
                String portStr = r.readLine();
                port = Integer.parseInt(portStr);
                r.close();
            }
            if (port > 0) {
                Socket s = new Socket(host, port);
                s.getOutputStream().write(shutdown.getBytes());
                s.close();
                long t = System.currentTimeMillis() + this.service.getStopTimeout();
                do {
                    Thread.sleep(100L);
                    this.checkProcess();
                } while (System.currentTimeMillis() < t && this.process != null);
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to cleanly shutdown instance", (Throwable)e);
        }
    }

    protected static boolean deleteFile(File fileToDelete) {
        if (fileToDelete == null || !fileToDelete.exists()) {
            return true;
        }
        boolean result = true;
        if (fileToDelete.isDirectory()) {
            File[] files = fileToDelete.listFiles();
            if (files == null) {
                result = false;
            } else {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.getName().equals(".") || file.getName().equals("..")) continue;
                    if (file.isDirectory()) {
                        result &= InstanceImpl.deleteFile(file);
                        continue;
                    }
                    result &= file.delete();
                }
            }
        }
        return result &= fileToDelete.delete();
    }

    protected static Properties loadPropertiesFile(URL configPropURL) throws Exception {
        Properties configProps = new Properties();
        InputStream is = null;
        try {
            is = configPropURL.openConnection().getInputStream();
            configProps.load(is);
            is.close();
        }
        catch (Exception ex) {
            System.err.println("Error loading config properties from " + configPropURL);
            System.err.println("Main: " + ex);
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return null;
        }
        return configProps;
    }

    protected static String substVars(String val, String currentKey, Map<String, String> cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = InstanceImpl.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }
}

