/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect.felix.framework.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.connect.felix.framework.ServiceRegistry;
import org.apache.felix.connect.felix.framework.util.ListenerInfo;
import org.apache.felix.connect.felix.framework.util.ShrinkableCollection;
import org.apache.felix.connect.felix.framework.util.ShrinkableList;
import org.apache.felix.connect.felix.framework.util.ShrinkableMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.ListenerHook;

public class EventDispatcher {
    private final ServiceRegistry m_registry;
    private Map<BundleContext, List<ListenerInfo>> m_fwkListeners = Collections.emptyMap();
    private Map<BundleContext, List<ListenerInfo>> m_bndlListeners = Collections.emptyMap();
    private Map<BundleContext, List<ListenerInfo>> m_syncBndlListeners = Collections.emptyMap();
    private Map<BundleContext, List<ListenerInfo>> m_svcListeners = Collections.emptyMap();
    private static Thread m_thread = null;
    private static final String m_threadLock = "thread lock";
    private static int m_references = 0;
    private static volatile boolean m_stopping = false;
    private static final List<Request> m_requestList = new ArrayList<Request>();
    private static final List<Request> m_requestPool = new ArrayList<Request>();
    private static final boolean m_sync = "true".equalsIgnoreCase(System.getProperty("org.apache.felix.connect.events.sync"));

    public EventDispatcher(ServiceRegistry registry) {
        this.m_registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDispatching() {
        String string = m_threadLock;
        synchronized (m_threadLock) {
            if (m_thread == null || !m_thread.isAlive()) {
                m_stopping = false;
                if (!m_sync) {
                    m_thread = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                EventDispatcher.run();
                            }
                            finally {
                                String string = EventDispatcher.m_threadLock;
                                synchronized (EventDispatcher.m_threadLock) {
                                    m_thread = null;
                                    m_stopping = false;
                                    m_references = 0;
                                    EventDispatcher.m_threadLock.notifyAll();
                                    // ** MonitorExit[var1_1] (shouldn't be in output)
                                }
                            }
                        }
                    }, "FelixDispatchQueue");
                    m_thread.start();
                }
            }
            ++m_references;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDispatching() {
        Object object = m_threadLock;
        synchronized (m_threadLock) {
            if (m_thread == null || m_stopping) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (--m_references > 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            m_stopping = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = m_requestList;
            synchronized (object) {
                m_requestList.notify();
            }
            object = m_threadLock;
            synchronized (m_threadLock) {
                while (m_thread != null) {
                    try {
                        m_threadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter addListener(BundleContext bc, Class clazz, EventListener l, Filter filter) {
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (!clazz.isInstance(l)) {
            throw new IllegalArgumentException("Listener not of type " + clazz.getName());
        }
        Filter oldFilter = this.updateListener(bc, clazz, l, filter);
        if (oldFilter != null) {
            return oldFilter;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            Map<BundleContext, List<ListenerInfo>> listeners;
            try {
                bc.getBundle();
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
            Object acc = null;
            if (clazz == FrameworkListener.class) {
                listeners = this.m_fwkListeners;
            } else if (clazz == BundleListener.class) {
                listeners = SynchronousBundleListener.class.isInstance(l) ? this.m_syncBndlListeners : this.m_bndlListeners;
            } else if (clazz == ServiceListener.class) {
                listeners = this.m_svcListeners;
            } else {
                throw new IllegalArgumentException("Unknown listener: " + l.getClass());
            }
            ListenerInfo info = new ListenerInfo(bc.getBundle(), bc, clazz, l, filter, acc, false);
            listeners = EventDispatcher.addListenerInfo(listeners, info);
            if (clazz == FrameworkListener.class) {
                this.m_fwkListeners = listeners;
            } else if (clazz == BundleListener.class) {
                if (SynchronousBundleListener.class.isInstance(l)) {
                    this.m_syncBndlListeners = listeners;
                } else {
                    this.m_bndlListeners = listeners;
                }
            } else if (clazz == ServiceListener.class) {
                this.m_svcListeners = listeners;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerHook.ListenerInfo removeListener(BundleContext bc, Class clazz, EventListener l) {
        ListenerInfo returnInfo = null;
        if (l == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        if (!clazz.isInstance(l)) {
            throw new IllegalArgumentException("Listener not of type " + clazz.getName());
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            Map<BundleContext, List<ListenerInfo>> listeners;
            if (clazz == FrameworkListener.class) {
                listeners = this.m_fwkListeners;
            } else if (clazz == BundleListener.class) {
                listeners = SynchronousBundleListener.class.isInstance(l) ? this.m_syncBndlListeners : this.m_bndlListeners;
            } else if (clazz == ServiceListener.class) {
                listeners = this.m_svcListeners;
            } else {
                throw new IllegalArgumentException("Unknown listener: " + l.getClass());
            }
            int idx = -1;
            block3: for (Map.Entry<BundleContext, List<ListenerInfo>> entry : listeners.entrySet()) {
                List<ListenerInfo> infos = entry.getValue();
                for (int i = 0; i < infos.size(); ++i) {
                    ListenerInfo info = infos.get(i);
                    if (!info.getBundleContext().equals(bc) || info.getListenerClass() != clazz || info.getListener() != l) continue;
                    if (ServiceListener.class == clazz) {
                        returnInfo = new ListenerInfo(infos.get(i), true);
                    }
                    idx = i;
                    continue block3;
                }
            }
            if (idx >= 0) {
                listeners = EventDispatcher.removeListenerInfo(listeners, bc, idx);
            }
            if (clazz == FrameworkListener.class) {
                this.m_fwkListeners = listeners;
            } else if (clazz == BundleListener.class) {
                if (SynchronousBundleListener.class.isInstance(l)) {
                    this.m_syncBndlListeners = listeners;
                } else {
                    this.m_bndlListeners = listeners;
                }
            } else if (clazz == ServiceListener.class) {
                this.m_svcListeners = listeners;
            }
        }
        return returnInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners(BundleContext bc) {
        if (bc == null) {
            return;
        }
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            this.m_fwkListeners = EventDispatcher.removeListenerInfos(this.m_fwkListeners, bc);
            this.m_bndlListeners = EventDispatcher.removeListenerInfos(this.m_bndlListeners, bc);
            this.m_syncBndlListeners = EventDispatcher.removeListenerInfos(this.m_syncBndlListeners, bc);
            this.m_svcListeners = EventDispatcher.removeListenerInfos(this.m_svcListeners, bc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter updateListener(BundleContext bc, Class clazz, EventListener l, Filter filter) {
        if (clazz == ServiceListener.class) {
            EventDispatcher eventDispatcher = this;
            synchronized (eventDispatcher) {
                try {
                    bc.getBundle();
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
                List<ListenerInfo> infos = this.m_svcListeners.get(bc);
                for (int i = 0; infos != null && i < infos.size(); ++i) {
                    ListenerInfo info = infos.get(i);
                    if (!info.getBundleContext().equals(bc) || info.getListenerClass() != clazz || info.getListener() != l) continue;
                    Filter oldFilter = info.getParsedFilter();
                    ListenerInfo newInfo = new ListenerInfo(info.getBundle(), info.getBundleContext(), info.getListenerClass(), info.getListener(), filter, info.getSecurityContext(), info.isRemoved());
                    this.m_svcListeners = EventDispatcher.updateListenerInfo(this.m_svcListeners, i, newInfo);
                    return oldFilter;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ListenerHook.ListenerInfo> getAllServiceListeners() {
        ArrayList<ListenerHook.ListenerInfo> listeners = new ArrayList<ListenerHook.ListenerInfo>();
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            for (Map.Entry<BundleContext, List<ListenerInfo>> entry : this.m_svcListeners.entrySet()) {
                listeners.addAll((Collection<ListenerHook.ListenerInfo>)entry.getValue());
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFrameworkEvent(FrameworkEvent event) {
        Map<BundleContext, List<ListenerInfo>> listeners;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            listeners = this.m_fwkListeners;
        }
        EventDispatcher.fireEventAsynchronously(this, 0, listeners, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireBundleEvent(BundleEvent event) {
        Map<BundleContext, List<ListenerInfo>> syncListeners;
        Map<BundleContext, List<ListenerInfo>> listeners;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            listeners = this.m_bndlListeners;
            syncListeners = this.m_syncBndlListeners;
        }
        Set<BundleContext> whitelist = this.createWhitelistFromHooks(event, event.getBundle(), listeners.keySet(), syncListeners.keySet());
        if (whitelist != null) {
            List<ListenerInfo> infos;
            HashMap<BundleContext, List<ListenerInfo>> copy = new HashMap<BundleContext, List<ListenerInfo>>();
            for (BundleContext bc : whitelist) {
                infos = listeners.get(bc);
                if (infos == null) continue;
                copy.put(bc, infos);
            }
            listeners = copy;
            copy = new HashMap();
            for (BundleContext bc : whitelist) {
                infos = syncListeners.get(bc);
                if (infos == null) continue;
                copy.put(bc, infos);
            }
            syncListeners = copy;
        }
        EventDispatcher.fireEventImmediately(this, 1, syncListeners, event, null);
        if (event.getType() != 128 && event.getType() != 256 && event.getType() != 512) {
            EventDispatcher.fireEventAsynchronously(this, 1, listeners, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<BundleContext> createWhitelistFromHooks(BundleEvent event, Bundle bundle, Set<BundleContext> listeners1, Set<BundleContext> listeners2) {
        if (bundle == null) {
            return null;
        }
        HashSet<BundleContext> whitelist = null;
        Set<ServiceReference<org.osgi.framework.hooks.bundle.EventHook>> hooks = this.m_registry.getHooks(org.osgi.framework.hooks.bundle.EventHook.class);
        if (hooks != null && !hooks.isEmpty()) {
            whitelist = new HashSet<BundleContext>();
            whitelist.addAll(listeners1);
            whitelist.addAll(listeners2);
            int originalSize = whitelist.size();
            ShrinkableCollection<BundleContext> shrinkable = new ShrinkableCollection<BundleContext>(whitelist);
            for (ServiceReference<org.osgi.framework.hooks.bundle.EventHook> sr : hooks) {
                try {
                    org.osgi.framework.hooks.bundle.EventHook eh = this.m_registry.getService(bundle, sr);
                    if (eh == null) continue;
                    try {
                        eh.event(event, shrinkable);
                    }
                    catch (Throwable th) {
                        System.out.println("Problem invoking bundle hook");
                        th.printStackTrace();
                    }
                    finally {
                        this.m_registry.ungetService(bundle, sr);
                    }
                }
                catch (Throwable th) {}
            }
            if (originalSize == whitelist.size()) {
                whitelist = null;
            }
        }
        return whitelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireServiceEvent(ServiceEvent event, Dictionary<String, ?> oldProps, Bundle framework) {
        Map<BundleContext, List<ListenerInfo>> listeners;
        EventDispatcher eventDispatcher = this;
        synchronized (eventDispatcher) {
            listeners = this.m_svcListeners;
        }
        listeners = this.filterListenersUsingHooks(event, framework, listeners);
        EventDispatcher.fireEventImmediately(this, 2, listeners, event, oldProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<BundleContext, List<ListenerInfo>> filterListenersUsingHooks(ServiceEvent event, Bundle framework, Map<BundleContext, List<ListenerInfo>> listeners) {
        Object shrink;
        if (framework == null) {
            return listeners;
        }
        Set<ServiceReference<EventHook>> ehs = this.m_registry.getHooks(EventHook.class);
        Set<ServiceReference<EventListenerHook>> elhs = this.m_registry.getHooks(EventListenerHook.class);
        if ((ehs == null || ehs.isEmpty()) && (elhs == null || elhs.isEmpty())) {
            return listeners;
        }
        HashMap<BundleContext, List<ListenerInfo>> shrinkableMap = new HashMap();
        for (Map.Entry<BundleContext, List<ListenerInfo>> entry : listeners.entrySet()) {
            ShrinkableList shrinkableList = new ShrinkableList(new ArrayList(entry.getValue()));
            shrinkableMap.put(entry.getKey(), shrinkableList);
        }
        shrinkableMap = new ShrinkableMap(shrinkableMap);
        if (ehs != null && !ehs.isEmpty()) {
            shrink = shrinkableMap.keySet();
            for (ServiceReference<Object> serviceReference : ehs) {
                try {
                    EventHook eh = (EventHook)this.m_registry.getService(framework, serviceReference);
                    if (eh == null) continue;
                    try {
                        eh.event(event, (Collection<BundleContext>)shrink);
                    }
                    catch (Throwable th) {
                        System.out.println("Problem invoking event hook");
                        th.printStackTrace();
                    }
                    finally {
                        this.m_registry.ungetService(framework, serviceReference);
                    }
                }
                catch (Throwable th) {}
            }
        }
        if (elhs != null && !elhs.isEmpty()) {
            shrink = shrinkableMap;
            for (ServiceReference<Object> serviceReference : elhs) {
                try {
                    EventListenerHook elh = (EventListenerHook)this.m_registry.getService(framework, serviceReference);
                    if (elh == null) continue;
                    try {
                        elh.event(event, (Map<BundleContext, Collection<ListenerHook.ListenerInfo>>)shrink);
                    }
                    catch (Throwable th) {
                        System.out.println("Problem invoking event hook");
                        th.printStackTrace();
                    }
                    finally {
                        this.m_registry.ungetService(framework, serviceReference);
                    }
                }
                catch (Throwable th) {}
            }
        }
        return shrinkableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireEventAsynchronously(EventDispatcher dispatcher, int type, Map<BundleContext, List<ListenerInfo>> listeners, EventObject event) {
        if (!m_sync) {
            Request req;
            if (m_stopping || m_thread == null) {
                return;
            }
            List<Request> list = m_requestPool;
            synchronized (list) {
                req = m_requestPool.size() > 0 ? m_requestPool.remove(0) : new Request();
            }
            req.m_dispatcher = dispatcher;
            req.m_type = type;
            req.m_listeners = listeners;
            req.m_event = event;
            list = m_requestList;
            synchronized (list) {
                m_requestList.add(req);
                m_requestList.notify();
            }
        }
        EventDispatcher.fireEventImmediately(dispatcher, type, listeners, event, null);
    }

    private static void fireEventImmediately(EventDispatcher dispatcher, int type, Map<BundleContext, List<ListenerInfo>> listeners, EventObject event, Dictionary<String, ?> oldProps) {
        if (!listeners.isEmpty()) {
            for (Map.Entry<BundleContext, List<ListenerInfo>> entry : listeners.entrySet()) {
                for (ListenerInfo info : entry.getValue()) {
                    Bundle bundle = info.getBundle();
                    EventListener l = info.getListener();
                    Filter filter = info.getParsedFilter();
                    Object acc = info.getSecurityContext();
                    try {
                        if (type == 0) {
                            EventDispatcher.invokeFrameworkListenerCallback(bundle, l, event);
                            continue;
                        }
                        if (type == 1) {
                            EventDispatcher.invokeBundleListenerCallback(bundle, l, event);
                            continue;
                        }
                        if (type != 2) continue;
                        EventDispatcher.invokeServiceListenerCallback(bundle, l, filter, acc, event, oldProps);
                    }
                    catch (Throwable th) {
                        if (type == 0 && ((FrameworkEvent)event).getType() == 2) continue;
                        System.out.println("EventDispatcher: Error during dispatch.");
                        th.printStackTrace();
                        dispatcher.fireFrameworkEvent(new FrameworkEvent(2, bundle, th));
                    }
                }
            }
        }
    }

    private static void invokeFrameworkListenerCallback(Bundle bundle, EventListener l, EventObject event) {
        if (bundle.getState() == 8 || bundle.getState() == 32) {
            ((FrameworkListener)l).frameworkEvent((FrameworkEvent)event);
        }
    }

    private static void invokeBundleListenerCallback(Bundle bundle, EventListener l, EventObject event) {
        if (SynchronousBundleListener.class.isAssignableFrom(l.getClass()) && (bundle.getState() == 8 || bundle.getState() == 16 || bundle.getState() == 32) || bundle.getState() == 8 || bundle.getState() == 32) {
            ((BundleListener)l).bundleChanged((BundleEvent)event);
        }
    }

    private static void invokeServiceListenerCallback(Bundle bundle, EventListener l, Filter filter, Object acc, EventObject event, Dictionary<String, ?> oldProps) {
        if (bundle.getState() != 8 && bundle.getState() != 16 && bundle.getState() != 32) {
            return;
        }
        ServiceReference<?> ref = ((ServiceEvent)event).getServiceReference();
        boolean hasPermission = true;
        if (hasPermission) {
            boolean matched;
            boolean bl = matched = filter == null || filter.match(((ServiceEvent)event).getServiceReference());
            if (matched) {
                ((ServiceListener)l).serviceChanged((ServiceEvent)event);
            } else if (((ServiceEvent)event).getType() == 2 && filter.match(oldProps)) {
                ServiceEvent se = new ServiceEvent(8, ((ServiceEvent)event).getServiceReference());
                ((ServiceListener)l).serviceChanged(se);
            }
        }
    }

    private static Map<BundleContext, List<ListenerInfo>> addListenerInfo(Map<BundleContext, List<ListenerInfo>> listeners, ListenerInfo info) {
        HashMap<BundleContext, List<ListenerInfo>> copy = new HashMap<BundleContext, List<ListenerInfo>>(listeners);
        ArrayList<ListenerInfo> infos = (ArrayList<ListenerInfo>)copy.remove(info.getBundleContext());
        infos = infos == null ? new ArrayList<ListenerInfo>() : new ArrayList(infos);
        infos.add(info);
        copy.put(info.getBundleContext(), infos);
        return copy;
    }

    private static Map<BundleContext, List<ListenerInfo>> updateListenerInfo(Map<BundleContext, List<ListenerInfo>> listeners, int idx, ListenerInfo info) {
        HashMap<BundleContext, List<ListenerInfo>> copy = new HashMap<BundleContext, List<ListenerInfo>>(listeners);
        List infos = (List)copy.remove(info.getBundleContext());
        if (infos != null) {
            ArrayList<ListenerInfo> copylist = new ArrayList<ListenerInfo>(infos);
            copylist.set(idx, info);
            copy.put(info.getBundleContext(), copylist);
            return copy;
        }
        return listeners;
    }

    private static Map<BundleContext, List<ListenerInfo>> removeListenerInfo(Map<BundleContext, List<ListenerInfo>> listeners, BundleContext bc, int idx) {
        HashMap<BundleContext, List<ListenerInfo>> copy = new HashMap<BundleContext, List<ListenerInfo>>(listeners);
        ArrayList infos = (ArrayList)copy.remove(bc);
        if (infos != null) {
            infos = new ArrayList(infos);
            infos.remove(idx);
            if (!infos.isEmpty()) {
                copy.put(bc, infos);
            }
            return copy;
        }
        return listeners;
    }

    private static Map<BundleContext, List<ListenerInfo>> removeListenerInfos(Map<BundleContext, List<ListenerInfo>> listeners, BundleContext bc) {
        HashMap<BundleContext, List<ListenerInfo>> copy = new HashMap<BundleContext, List<ListenerInfo>>(listeners);
        copy.remove(bc);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run() {
        while (true) {
            Request req;
            List<Request> list = m_requestList;
            synchronized (list) {
                while (m_requestList.isEmpty() && !m_stopping) {
                    try {
                        m_requestList.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (m_requestList.isEmpty() && m_stopping) {
                    return;
                }
                req = m_requestList.remove(0);
            }
            EventDispatcher.fireEventImmediately(req.m_dispatcher, req.m_type, req.m_listeners, req.m_event, null);
            list = m_requestPool;
            synchronized (list) {
                req.m_dispatcher = null;
                req.m_type = -1;
                req.m_listeners = null;
                req.m_event = null;
                m_requestPool.add(req);
            }
        }
    }

    private static class Request {
        public static final int FRAMEWORK_EVENT = 0;
        public static final int BUNDLE_EVENT = 1;
        public static final int SERVICE_EVENT = 2;
        public EventDispatcher m_dispatcher = null;
        public int m_type = -1;
        public Map<BundleContext, List<ListenerInfo>> m_listeners = null;
        public EventObject m_event = null;

        private Request() {
        }
    }
}

