/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect.felix.framework;

import java.net.ContentHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.felix.connect.felix.framework.ServiceRegistrationImpl;
import org.apache.felix.connect.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.connect.felix.framework.capabilityset.SimpleFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.service.url.URLStreamHandlerService;

public class ServiceRegistry {
    private long m_currentServiceId = 1L;
    private final Map<Bundle, ServiceRegistration[]> m_regsMap = Collections.synchronizedMap(new HashMap());
    private final CapabilitySet<ServiceRegistrationImpl.ServiceReferenceImpl> m_regCapSet;
    private final Map<ServiceRegistrationImpl, Thread> m_lockedRegsMap = new HashMap<ServiceRegistrationImpl, Thread>();
    private final Map<Bundle, UsageCount[]> m_inUseMap = new HashMap<Bundle, UsageCount[]>();
    private final ServiceRegistryCallbacks m_callbacks;
    private final WeakHashMap<ServiceReference, ServiceReference> m_blackList = new WeakHashMap();
    private static final Class<?>[] m_hookClasses = new Class[]{org.osgi.framework.hooks.bundle.FindHook.class, org.osgi.framework.hooks.bundle.EventHook.class, EventHook.class, EventListenerHook.class, FindHook.class, ListenerHook.class, WeavingHook.class, ResolverHookFactory.class, URLStreamHandlerService.class, ContentHandler.class};
    private final Map<Class<?>, Set<ServiceReference<?>>> m_allHooks = new HashMap();

    public ServiceRegistry(ServiceRegistryCallbacks callbacks) {
        this.m_callbacks = callbacks;
        this.m_regCapSet = new CapabilitySet(Collections.singletonList("objectClass"), false);
    }

    public ServiceReference[] getRegisteredServices(Bundle bundle) {
        ServiceRegistration[] regs = this.m_regsMap.get(bundle);
        if (regs != null) {
            ArrayList refs = new ArrayList(regs.length);
            for (ServiceRegistration reg : regs) {
                try {
                    refs.add(reg.getReference());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return refs.toArray(new ServiceReference[refs.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration registerService(Bundle bundle, String[] classNames, Object svcObj, Dictionary dict) {
        ServiceRegistrationImpl reg = null;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            reg = new ServiceRegistrationImpl(this, bundle, classNames, this.m_currentServiceId++, svcObj, dict);
            this.addHooks(classNames, svcObj, reg.getReference());
            ServiceRegistration[] regs = this.m_regsMap.get(bundle);
            this.m_regsMap.put(bundle, ServiceRegistry.addServiceRegistration(regs, reg));
            this.m_regCapSet.addCapability((ServiceRegistrationImpl.ServiceReferenceImpl)reg.getReference());
        }
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(1, reg.getReference()), null);
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(Bundle bundle, ServiceRegistrationImpl reg) {
        this.removeHook(reg.getReference());
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            ServiceRegistration[] regs = this.m_regsMap.get(bundle);
            this.m_regsMap.put(bundle, ServiceRegistry.removeServiceRegistration(regs, reg));
            this.m_regCapSet.removeCapability((ServiceRegistrationImpl.ServiceReferenceImpl)reg.getReference());
        }
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(4, reg.getReference()), null);
        }
        serviceRegistry = this;
        synchronized (serviceRegistry) {
            Bundle[] clients = this.getUsingBundles(reg.getReference());
            for (int i = 0; clients != null && i < clients.length; ++i) {
                while (this.ungetService(clients[i], reg.getReference())) {
                }
            }
            reg.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServices(Bundle bundle) {
        ServiceRegistration[] regs = null;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            regs = this.m_regsMap.get(bundle);
        }
        for (int i = 0; regs != null && i < regs.length; ++i) {
            if (!((ServiceRegistrationImpl)regs[i]).isValid()) continue;
            regs[i].unregister();
        }
        ServiceRegistry serviceRegistry2 = this;
        synchronized (serviceRegistry2) {
            this.m_regsMap.remove(bundle);
        }
    }

    public synchronized Collection<ServiceReference<?>> getServiceReferences(String className, SimpleFilter filter) {
        if (className == null && filter == null) {
            filter = new SimpleFilter("objectClass", "*", 8);
        } else if (className != null && filter == null) {
            filter = new SimpleFilter("objectClass", className, 4);
        } else if (className != null && filter != null) {
            ArrayList<SimpleFilter> filters = new ArrayList<SimpleFilter>(2);
            filters.add(new SimpleFilter("objectClass", className, 4));
            filters.add(filter);
            filter = new SimpleFilter(null, filters, 1);
        }
        Set<ServiceReference<?>> matches = this.m_regCapSet.match(filter, false);
        return matches;
    }

    public synchronized ServiceReference[] getServicesInUse(Bundle bundle) {
        UsageCount[] usages = this.m_inUseMap.get(bundle);
        if (usages != null) {
            ServiceReference[] refs = new ServiceReference[usages.length];
            for (int i = 0; i < refs.length; ++i) {
                refs[i] = usages[i].m_ref;
            }
            return refs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> S getService(Bundle bundle, ServiceReference<S> ref) {
        UsageCount usage = null;
        Object svcObj = null;
        ServiceRegistrationImpl reg = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration();
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            Thread o = this.m_lockedRegsMap.get(reg);
            while (o != null) {
                if (o.equals(Thread.currentThread())) {
                    throw new ServiceException("ServiceFactory.getService() resulted in a cycle.", 2, null);
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                o = this.m_lockedRegsMap.get(reg);
            }
            this.m_lockedRegsMap.put(reg, Thread.currentThread());
            if (reg.isValid()) {
                usage = this.getUsageCount(bundle, ref);
                if (usage == null) {
                    usage = this.addUsageCount(bundle, ref);
                }
                ++usage.m_count;
                svcObj = usage.m_svcObj;
            }
        }
        try {
            if (usage != null && svcObj == null) {
                svcObj = reg.getService(bundle);
            }
        }
        finally {
            serviceRegistry = this;
            synchronized (serviceRegistry) {
                if (!reg.isValid() || svcObj == null) {
                    this.flushUsageCount(bundle, ref);
                } else {
                    usage.m_svcObj = svcObj;
                }
                this.m_lockedRegsMap.remove(reg);
                this.notifyAll();
            }
        }
        return (S)svcObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ungetService(Bundle bundle, ServiceReference ref) {
        UsageCount usage = null;
        ServiceRegistrationImpl reg = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration();
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            Thread o = this.m_lockedRegsMap.get(reg);
            while (o != null) {
                if (o.equals(Thread.currentThread())) {
                    throw new IllegalStateException("ServiceFactory.ungetService() resulted in a cycle.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                o = this.m_lockedRegsMap.get(reg);
            }
            usage = this.getUsageCount(bundle, ref);
            if (usage == null) {
                return false;
            }
            this.m_lockedRegsMap.put(reg, Thread.currentThread());
        }
        try {
            if (usage.m_count == 1) {
                ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration().ungetService(bundle, usage.m_svcObj);
            }
        }
        finally {
            serviceRegistry = this;
            synchronized (serviceRegistry) {
                --usage.m_count;
                if (!reg.isValid() || usage.m_count <= 0) {
                    usage.m_svcObj = null;
                    this.flushUsageCount(bundle, ref);
                }
                this.m_lockedRegsMap.remove(reg);
                this.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetServices(Bundle bundle) {
        UsageCount[] usageCountArray = this;
        synchronized (this) {
            UsageCount[] usages = this.m_inUseMap.get(bundle);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (usages == null) {
                return;
            }
            for (UsageCount usage : usages) {
                while (this.ungetService(bundle, usage.m_ref)) {
                }
            }
            return;
        }
    }

    public synchronized Bundle[] getUsingBundles(ServiceReference ref) {
        Bundle[] bundles = null;
        for (Map.Entry<Bundle, UsageCount[]> entry : this.m_inUseMap.entrySet()) {
            UsageCount[] usages;
            Bundle bundle = entry.getKey();
            for (UsageCount usage : usages = entry.getValue()) {
                if (!usage.m_ref.equals(ref)) continue;
                if (bundles == null) {
                    bundles = new Bundle[]{bundle};
                    continue;
                }
                Bundle[] nbs = new Bundle[bundles.length + 1];
                System.arraycopy(bundles, 0, nbs, 0, bundles.length);
                nbs[bundles.length] = bundle;
                bundles = nbs;
            }
        }
        return bundles;
    }

    void servicePropertiesModified(ServiceRegistration reg, Dictionary oldProps) {
        this.updateHook(reg.getReference());
        if (this.m_callbacks != null) {
            this.m_callbacks.serviceChanged(new ServiceEvent(2, reg.getReference()), oldProps);
        }
    }

    private static ServiceRegistration[] addServiceRegistration(ServiceRegistration[] regs, ServiceRegistration reg) {
        if (regs == null) {
            regs = new ServiceRegistration[]{reg};
        } else {
            ServiceRegistration[] newRegs = new ServiceRegistration[regs.length + 1];
            System.arraycopy(regs, 0, newRegs, 0, regs.length);
            newRegs[regs.length] = reg;
            regs = newRegs;
        }
        return regs;
    }

    private static ServiceRegistration[] removeServiceRegistration(ServiceRegistration[] regs, ServiceRegistration reg) {
        for (int i = 0; regs != null && i < regs.length; ++i) {
            if (!regs[i].equals(reg)) continue;
            if (regs.length - 1 == 0) {
                regs = new ServiceRegistration[]{};
                continue;
            }
            ServiceRegistration[] newRegs = new ServiceRegistration[regs.length - 1];
            System.arraycopy(regs, 0, newRegs, 0, i);
            if (i < newRegs.length) {
                System.arraycopy(regs, i + 1, newRegs, i, newRegs.length - i);
            }
            regs = newRegs;
        }
        return regs;
    }

    private UsageCount getUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = this.m_inUseMap.get(bundle);
        for (int i = 0; usages != null && i < usages.length; ++i) {
            if (!usages[i].m_ref.equals(ref)) continue;
            return usages[i];
        }
        return null;
    }

    private UsageCount addUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = this.m_inUseMap.get(bundle);
        UsageCount usage = new UsageCount();
        usage.m_ref = ref;
        if (usages == null) {
            usages = new UsageCount[]{usage};
        } else {
            UsageCount[] newUsages = new UsageCount[usages.length + 1];
            System.arraycopy(usages, 0, newUsages, 0, usages.length);
            newUsages[usages.length] = usage;
            usages = newUsages;
        }
        this.m_inUseMap.put(bundle, usages);
        return usage;
    }

    private void flushUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = this.m_inUseMap.get(bundle);
        for (int i = 0; usages != null && i < usages.length; ++i) {
            if (!usages[i].m_ref.equals(ref)) continue;
            if (usages.length - 1 == 0) {
                usages = null;
                continue;
            }
            UsageCount[] newUsages = new UsageCount[usages.length - 1];
            System.arraycopy(usages, 0, newUsages, 0, i);
            if (i < newUsages.length) {
                System.arraycopy(usages, i + 1, newUsages, i, newUsages.length - i);
            }
            usages = newUsages;
        }
        if (usages != null) {
            this.m_inUseMap.put(bundle, usages);
        } else {
            this.m_inUseMap.remove(bundle);
        }
    }

    boolean isHookBlackListed(ServiceReference sr) {
        return this.m_blackList.containsKey(sr);
    }

    void blackListHook(ServiceReference sr) {
        this.m_blackList.put(sr, sr);
    }

    static boolean isHook(String[] classNames, Class<?> hookClass, Object svcObj) {
        if (svcObj instanceof ServiceFactory) {
            for (String className : classNames) {
                if (!className.equals(hookClass.getName())) continue;
                return true;
            }
        }
        if (hookClass.isAssignableFrom(svcObj.getClass())) {
            String hookName = hookClass.getName();
            for (String className : classNames) {
                if (!className.equals(hookName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHooks(String[] classNames, Object svcObj, ServiceReference<?> ref) {
        for (Class<?> hookClass : m_hookClasses) {
            if (!ServiceRegistry.isHook(classNames, hookClass, svcObj)) continue;
            Map<Class<?>, Set<ServiceReference<?>>> map = this.m_allHooks;
            synchronized (map) {
                Set<ServiceReference<?>> hooks = this.m_allHooks.get(hookClass);
                if (hooks == null) {
                    hooks = new TreeSet(Collections.reverseOrder());
                    this.m_allHooks.put(hookClass, hooks);
                }
                hooks.add(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHook(ServiceReference ref) {
        Object svcObj = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration().getService();
        String[] classNames = (String[])ref.getProperty("objectClass");
        for (Class<?> hookClass : m_hookClasses) {
            if (!ServiceRegistry.isHook(classNames, hookClass, svcObj)) continue;
            Map<Class<?>, Set<ServiceReference<?>>> map = this.m_allHooks;
            synchronized (map) {
                Set<ServiceReference<?>> hooks = this.m_allHooks.get(hookClass);
                if (hooks != null) {
                    ArrayList refs = new ArrayList(hooks);
                    hooks.clear();
                    hooks.addAll(refs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHook(ServiceReference ref) {
        Object svcObj = ((ServiceRegistrationImpl.ServiceReferenceImpl)ref).getRegistration().getService();
        String[] classNames = (String[])ref.getProperty("objectClass");
        for (Class<?> hookClass : m_hookClasses) {
            if (!ServiceRegistry.isHook(classNames, hookClass, svcObj)) continue;
            Map<Class<?>, Set<ServiceReference<?>>> map = this.m_allHooks;
            synchronized (map) {
                Set<ServiceReference<?>> hooks = this.m_allHooks.get(hookClass);
                if (hooks != null) {
                    hooks.remove(ref);
                    if (hooks.isEmpty()) {
                        this.m_allHooks.remove(hookClass);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> Set<ServiceReference<S>> getHooks(Class<S> hookClass) {
        Map<Class<?>, Set<ServiceReference<?>>> map = this.m_allHooks;
        synchronized (map) {
            Set<ServiceReference<?>> hooks = this.m_allHooks.get(hookClass);
            if (hooks != null) {
                TreeSet<ServiceReference<S>> sorted = new TreeSet<ServiceReference<S>>(Collections.reverseOrder());
                sorted.addAll(hooks);
                return sorted;
            }
            return Collections.emptySet();
        }
    }

    public static interface ServiceRegistryCallbacks {
        public void serviceChanged(ServiceEvent var1, Dictionary<String, ?> var2);
    }

    private static class UsageCount {
        public int m_count = 0;
        public ServiceReference m_ref = null;
        public Object m_svcObj = null;

        private UsageCount() {
        }
    }
}

