/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.bayeux;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelId {
    public static final String WILD = "*";
    public static final String DEEPWILD = "**";
    private final String _id;
    private volatile String[] _segments;
    private int _wild;
    private List<String> _wilds;
    private String _parent;

    public ChannelId(String id) {
        if (id == null || id.length() == 0 || id.charAt(0) != '/' || "/".equals(id)) {
            throw new IllegalArgumentException("Invalid channel id: " + id);
        }
        if ((id = id.trim()).charAt(id.length() - 1) == '/') {
            id = id.substring(0, id.length() - 1);
        }
        this._id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        ChannelId channelId = this;
        synchronized (channelId) {
            if (this._segments != null) {
                return;
            }
            String[] segments = this._id.substring(1).split("/");
            if (segments.length < 1) {
                throw new IllegalArgumentException("Invalid channel id:" + this);
            }
            String lastSegment = segments[segments.length - 1];
            int wild = 0;
            if (WILD.equals(lastSegment)) {
                wild = 1;
            } else if (DEEPWILD.equals(lastSegment)) {
                wild = 2;
            }
            this._wild = wild;
            if (wild > 0) {
                this._wilds = Collections.emptyList();
            } else {
                String[] wilds = new String[segments.length + 1];
                StringBuilder b = new StringBuilder(this._id.length());
                b.append('/');
                for (int i = 0; i < segments.length; ++i) {
                    if (segments[i].trim().length() == 0) {
                        throw new IllegalArgumentException("Invalid channel id:" + this);
                    }
                    if (i > 0) {
                        b.append(segments[i - 1]).append('/');
                    }
                    wilds[segments.length - i] = b + DEEPWILD;
                }
                wilds[0] = b + WILD;
                this._wilds = Collections.unmodifiableList(Arrays.asList(wilds));
            }
            this._parent = segments.length == 1 ? null : this._id.substring(0, this._id.length() - lastSegment.length() - 1);
            this._segments = segments;
        }
    }

    public boolean isWild() {
        this.resolve();
        return this._wild > 0;
    }

    public boolean isShallowWild() {
        return this.isWild() && !this.isDeepWild();
    }

    public boolean isDeepWild() {
        this.resolve();
        return this._wild > 1;
    }

    public boolean isMeta() {
        return ChannelId.isMeta(this._id);
    }

    public boolean isService() {
        return ChannelId.isService(this._id);
    }

    public boolean isBroadcast() {
        return ChannelId.isBroadcast(this._id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChannelId)) {
            return false;
        }
        ChannelId that = (ChannelId)obj;
        return this._id.equals(that._id);
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public boolean matches(ChannelId channelId) {
        this.resolve();
        if (channelId.isWild()) {
            return this.equals(channelId);
        }
        switch (this._wild) {
            case 0: {
                return this.equals(channelId);
            }
            case 1: {
                if (channelId._segments.length != this._segments.length) {
                    return false;
                }
                int i = this._segments.length - 1;
                while (i-- > 0) {
                    if (this._segments[i].equals(channelId._segments[i])) continue;
                    return false;
                }
                return true;
            }
            case 2: {
                if (channelId._segments.length < this._segments.length) {
                    return false;
                }
                int i = this._segments.length - 1;
                while (i-- > 0) {
                    if (this._segments[i].equals(channelId._segments[i])) continue;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return this._id;
    }

    public int depth() {
        this.resolve();
        return this._segments.length;
    }

    public boolean isAncestorOf(ChannelId id) {
        this.resolve();
        if (this.isWild() || this.depth() >= id.depth()) {
            return false;
        }
        int i = this._segments.length;
        while (i-- > 0) {
            if (this._segments[i].equals(id._segments[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isParentOf(ChannelId id) {
        this.resolve();
        if (this.isWild() || this.depth() != id.depth() - 1) {
            return false;
        }
        int i = this._segments.length;
        while (i-- > 0) {
            if (this._segments[i].equals(id._segments[i])) continue;
            return false;
        }
        return true;
    }

    public String getParent() {
        this.resolve();
        return this._parent;
    }

    public String getSegment(int i) {
        this.resolve();
        if (i >= this._segments.length) {
            return null;
        }
        return this._segments[i];
    }

    public List<String> getWilds() {
        this.resolve();
        return this._wilds;
    }

    public static boolean isMeta(String channelId) {
        return channelId != null && channelId.startsWith("/meta/");
    }

    public static boolean isService(String channelId) {
        return channelId != null && channelId.startsWith("/service/");
    }

    public static boolean isBroadcast(String channelId) {
        return !ChannelId.isMeta(channelId) && !ChannelId.isService(channelId);
    }
}

