/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class PathResource
extends Resource {
    private static final Logger LOG = Log.getLogger(PathResource.class);
    private final Path path;
    private final URI uri;
    private LinkOption[] linkOptions = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    public PathResource(File file) {
        this(file.toPath());
    }

    public PathResource(Path path) {
        this.path = path;
        this.uri = this.path.toUri();
    }

    public PathResource(URI uri) throws IOException {
        Path path;
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("not an absolute uri");
        }
        if (!uri.getScheme().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("not file: scheme");
        }
        try {
            path = new File(uri).toPath();
        }
        catch (InvalidPathException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.ignore(e);
            throw new IOException("Unable to build Path from: " + uri, e);
        }
        this.path = path;
        this.uri = path.toUri();
    }

    public PathResource(URL url) throws IOException, URISyntaxException {
        this(url.toURI());
    }

    @Override
    public Resource addPath(String apath) throws IOException, MalformedURLException {
        return new PathResource(this.path.resolve(apath));
    }

    public void close() {
    }

    @Override
    public boolean delete() throws SecurityException {
        try {
            return Files.deleteIfExists(this.path);
        }
        catch (IOException e) {
            LOG.ignore(e);
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathResource other = (PathResource)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public boolean exists() {
        return Files.exists(this.path, this.linkOptions);
    }

    @Override
    public File getFile() throws IOException {
        return this.path.toFile();
    }

    public boolean getFollowLinks() {
        return this.linkOptions != null && this.linkOptions.length > 0 && this.linkOptions[0] == LinkOption.NOFOLLOW_LINKS;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, StandardOpenOption.READ);
    }

    @Override
    public String getName() {
        return this.path.toAbsolutePath().toString();
    }

    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return FileChannel.open(this.path, StandardOpenOption.READ);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public URL getURL() {
        try {
            return this.path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    @Override
    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.path, this.linkOptions);
    }

    @Override
    public long lastModified() {
        try {
            FileTime ft = Files.getLastModifiedTime(this.path, this.linkOptions);
            return ft.toMillis();
        }
        catch (IOException e) {
            LOG.ignore(e);
            return 0L;
        }
    }

    @Override
    public long length() {
        try {
            return Files.size(this.path);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public URI getAlias() {
        if (Files.isSymbolicLink(this.path)) {
            try {
                return this.path.toRealPath(new LinkOption[0]).toUri();
            }
            catch (IOException e) {
                LOG.debug(e);
                return null;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] list() {
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(this.path);){
            ArrayList<String> entries = new ArrayList<String>();
            for (Path entry : dir) {
                String name = entry.getFileName().toString();
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    name = name + "/";
                }
                entries.add(name);
            }
            int size = entries.size();
            String[] stringArray = entries.toArray(new String[size]);
            return stringArray;
        }
        catch (DirectoryIteratorException e) {
            LOG.debug(e);
            return null;
        }
        catch (IOException e) {
            LOG.debug(e);
        }
        return null;
    }

    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        if (dest instanceof PathResource) {
            PathResource destRes = (PathResource)dest;
            try {
                Path result = Files.move(this.path, destRes.path, StandardCopyOption.ATOMIC_MOVE);
                return Files.exists(result, this.linkOptions);
            }
            catch (IOException e) {
                LOG.ignore(e);
                return false;
            }
        }
        return false;
    }

    public void setFollowLinks(boolean followLinks) {
        this.linkOptions = followLinks ? new LinkOption[0] : new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    }
}

