/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.api.ComponentType;
import org.apache.felix.ipojo.api.Dependency;
import org.apache.felix.ipojo.api.HandlerConfiguration;
import org.apache.felix.ipojo.api.Property;
import org.apache.felix.ipojo.api.Service;
import org.apache.felix.ipojo.api.TemporalDependency;
import org.apache.felix.ipojo.manipulation.Manipulator;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.BundleContext;

public class PrimitiveComponentType
extends ComponentType {
    private BundleContext m_context;
    private String m_classname;
    private String m_name;
    private String m_version;
    private boolean m_immediate;
    private Element m_manipulation;
    private ComponentFactory m_factory;
    private List<Service> m_services = new ArrayList<Service>(1);
    private List<Dependency> m_dependencies = new ArrayList<Dependency>();
    private List<Property> m_properties = new ArrayList<Property>();
    private String m_validate;
    private String m_invalidate;
    private String m_updated;
    private boolean m_propagation;
    private String m_factoryMethod;
    private boolean m_public = true;
    private String m_msPID;
    private ArrayList<TemporalDependency> m_temporals = new ArrayList();
    private List<HandlerConfiguration> m_handlers = new ArrayList<HandlerConfiguration>();
    private boolean m_alreadyManipulated = false;

    private void ensureNotInitialized() {
        if (this.m_factory != null) {
            throw new IllegalStateException("The component type was already initialized, cannot modify metadata");
        }
    }

    private void ensureValidity() {
        if (this.m_classname == null) {
            throw new IllegalStateException("The primitive component type has no implementation class");
        }
        if (this.m_context == null) {
            throw new IllegalStateException("The primitive component type has no bundle context");
        }
    }

    public Factory getFactory() {
        this.initializeFactory();
        return this.m_factory;
    }

    public void start() {
        this.initializeFactory();
        this.m_factory.start();
    }

    public void stop() {
        this.initializeFactory();
        this.m_factory.stop();
    }

    private void initializeFactory() {
        if (this.m_factory == null) {
            this.createFactory();
        }
    }

    public PrimitiveComponentType setBundleContext(BundleContext bc) {
        this.ensureNotInitialized();
        this.m_context = bc;
        return this;
    }

    public PrimitiveComponentType setClassName(String classname) {
        this.ensureNotInitialized();
        this.m_classname = classname;
        return this;
    }

    public PrimitiveComponentType setComponentTypeName(String name) {
        this.ensureNotInitialized();
        this.m_name = name;
        return this;
    }

    public PrimitiveComponentType setComponentTypeVersion(String version) {
        this.ensureNotInitialized();
        this.m_version = version;
        return this;
    }

    public PrimitiveComponentType setImmediate(boolean immediate) {
        this.ensureNotInitialized();
        this.m_immediate = immediate;
        return this;
    }

    public PrimitiveComponentType setFactoryMethod(String method) {
        this.ensureNotInitialized();
        this.m_factoryMethod = method;
        return this;
    }

    public PrimitiveComponentType setPropagation(boolean propagation) {
        this.ensureNotInitialized();
        this.m_propagation = propagation;
        return this;
    }

    public PrimitiveComponentType setPublic(boolean visible) {
        this.ensureNotInitialized();
        this.m_public = visible;
        return this;
    }

    public PrimitiveComponentType setManagedServicePID(String pid) {
        this.ensureNotInitialized();
        this.m_msPID = pid;
        return this;
    }

    public PrimitiveComponentType setValidateMethod(String method) {
        this.ensureNotInitialized();
        this.m_validate = method;
        return this;
    }

    public PrimitiveComponentType setInvalidateMethod(String method) {
        this.ensureNotInitialized();
        this.m_invalidate = method;
        return this;
    }

    public PrimitiveComponentType setUpdatedMethod(String method) {
        this.ensureNotInitialized();
        this.m_updated = method;
        return this;
    }

    private Element generateComponentMetadata() {
        Element callback;
        Element element = new Element("component", "");
        element.addAttribute(new Attribute("classname", this.m_classname));
        if (this.m_name != null) {
            element.addAttribute(new Attribute("name", this.m_name));
        }
        if (this.m_version != null) {
            element.addAttribute(new Attribute("version", this.m_version));
        }
        if (this.m_factoryMethod != null) {
            element.addAttribute(new Attribute("factory-method", this.m_factoryMethod));
        }
        if (!this.m_public) {
            element.addAttribute(new Attribute("public", "false"));
        }
        if (this.m_immediate) {
            element.addAttribute(new Attribute("immediate", "true"));
        }
        for (Service service : this.m_services) {
            element.addElement(service.getElement());
        }
        for (Dependency dependency : this.m_dependencies) {
            element.addElement(dependency.getElement());
        }
        for (TemporalDependency temporalDependency : this.m_temporals) {
            element.addElement(temporalDependency.getElement());
        }
        if (this.m_validate != null) {
            callback = new Element("callback", "");
            callback.addAttribute(new Attribute("transition", "validate"));
            callback.addAttribute(new Attribute("method", this.m_validate));
            element.addElement(callback);
        }
        if (this.m_invalidate != null) {
            callback = new Element("callback", "");
            callback.addAttribute(new Attribute("transition", "invalidate"));
            callback.addAttribute(new Attribute("method", this.m_invalidate));
            element.addElement(callback);
        }
        if (this.m_propagation || this.m_msPID != null || !this.m_properties.isEmpty()) {
            Element properties = new Element("properties", "");
            if (this.m_propagation) {
                properties.addAttribute(new Attribute("propagation", "true"));
            }
            if (this.m_msPID != null) {
                properties.addAttribute(new Attribute("pid", this.m_msPID));
            }
            if (this.m_updated != null) {
                properties.addAttribute(new Attribute("updated", this.m_updated));
            }
            for (Property prop : this.m_properties) {
                properties.addElement(prop.getElement());
            }
            element.addElement(properties);
        }
        for (HandlerConfiguration handlerConfiguration : this.m_handlers) {
            element.addElement(handlerConfiguration.getElement());
        }
        return element;
    }

    public PrimitiveComponentType addHandler(HandlerConfiguration handler) {
        this.m_handlers.add(handler);
        return this;
    }

    private void createFactory() {
        this.ensureValidity();
        byte[] clazz = this.manipulate();
        Element meta = this.generateComponentMetadata();
        meta.addElement(this.m_manipulation);
        try {
            if (this.m_alreadyManipulated) {
                this.m_factory = new ComponentFactory(this.m_context, meta);
            } else {
                this.m_factory = new ComponentFactory(this.m_context, clazz, meta);
                this.m_factory.setUseFactoryClassloader(true);
            }
            this.m_factory.start();
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException("An exception occurs during factory initialization", e);
        }
    }

    private byte[] manipulate() {
        Manipulator manipulator = new Manipulator(new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                try {
                    return PrimitiveComponentType.this.m_context.getBundle().loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    return this.getClass().getClassLoader().loadClass(name);
                }
            }
        });
        try {
            byte[] array = this.getClassByteArray();
            manipulator.prepare(array);
            byte[] newclazz = new byte[]{};
            if (!manipulator.isAlreadyManipulated()) {
                newclazz = manipulator.manipulate(array);
            }
            this.m_manipulation = manipulator.getManipulationMetadata();
            this.m_alreadyManipulated = manipulator.isAlreadyManipulated();
            return newclazz;
        }
        catch (IOException e) {
            throw new IllegalStateException("An exception occurs during implementation class manipulation", e);
        }
    }

    private byte[] getClassByteArray() throws IOException {
        String filename = this.m_classname.replace('.', '/') + ".class";
        URL url = this.m_context.getBundle().getResource(filename);
        if (url == null) {
            throw new IllegalStateException("An exception occurs during implementation class manipulation : cannot found the class file " + filename);
        }
        InputStream is = url.openStream();
        if (is == null) {
            throw new IllegalStateException("An exception occurs during implementation class manipulation : cannot read the class file " + url);
        }
        byte[] b = new byte[is.available()];
        is.read(b);
        return b;
    }

    public PrimitiveComponentType addService(Service svc) {
        this.ensureNotInitialized();
        this.m_services.add(svc);
        return this;
    }

    public PrimitiveComponentType addDependency(Dependency dep) {
        this.ensureNotInitialized();
        this.m_dependencies.add(dep);
        return this;
    }

    public PrimitiveComponentType addDependency(TemporalDependency dep) {
        this.ensureNotInitialized();
        this.m_temporals.add(dep);
        return this;
    }

    public PrimitiveComponentType addProperty(Property prop) {
        this.ensureNotInitialized();
        this.m_properties.add(prop);
        return this;
    }

    public PrimitiveComponentType addProperty(String key, Object obj) {
        String value = null;
        if (obj != null) {
            value = obj.toString();
        }
        this.addProperty(new Property().setName(key).setValue(value));
        return this;
    }
}

