/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.api.composite;

import org.apache.felix.ipojo.api.HandlerConfiguration;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class ExportedService
implements HandlerConfiguration {
    private String m_specification;
    private String m_filter;
    private boolean m_optional;
    private boolean m_aggregate;
    private int m_policy = 0;
    private String m_comparator;

    public Element getElement() {
        this.ensureValidity();
        Element dep = new Element("provides", "");
        dep.addAttribute(new Attribute("action", "export"));
        dep.addAttribute(new Attribute("specification", this.m_specification));
        if (this.m_filter != null) {
            dep.addAttribute(new Attribute("filter", this.m_filter));
        }
        if (this.m_comparator != null) {
            dep.addAttribute(new Attribute("comparator", this.m_comparator));
        }
        if (this.m_optional) {
            dep.addAttribute(new Attribute("optional", "true"));
        }
        if (this.m_aggregate) {
            dep.addAttribute(new Attribute("aggregate", "true"));
        }
        if (this.m_policy == 0) {
            dep.addAttribute(new Attribute("policy", "dynamic"));
        } else if (this.m_policy == 1) {
            dep.addAttribute(new Attribute("policy", "static"));
        } else if (this.m_policy == 2) {
            dep.addAttribute(new Attribute("policy", "dynamic-priority"));
        }
        return dep;
    }

    public ExportedService setSpecification(String spec) {
        this.m_specification = spec;
        return this;
    }

    public ExportedService setFilter(String filter) {
        this.m_filter = filter;
        return this;
    }

    public ExportedService setOptional(boolean opt) {
        this.m_optional = opt;
        return this;
    }

    public ExportedService setAggregate(boolean agg) {
        this.m_aggregate = agg;
        return this;
    }

    public ExportedService setBindingPolicy(int policy) {
        this.m_policy = policy;
        return this;
    }

    public ExportedService setComparator(String cmp) {
        this.m_comparator = cmp;
        return this;
    }

    private void ensureValidity() {
        if (this.m_specification == null) {
            throw new IllegalStateException("The specification of the exported service must be set");
        }
        if (this.m_policy != 0 && this.m_policy != 1 && this.m_policy != 2) {
            throw new IllegalStateException("Unknown binding policy : " + this.m_policy);
        }
    }
}

