/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.manipulator.MetadataProvider;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.ResourceVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.ClassMetadataCollector;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Bindings;
import org.apache.felix.ipojo.manipulator.spi.ModuleProvider;
import org.apache.felix.ipojo.manipulator.spi.provider.CoreModuleProvider;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.ClassReader;

public class AnnotationMetadataProvider
implements MetadataProvider {
    private ResourceStore m_store;
    private Reporter m_reporter;
    private BindingRegistry m_registry;

    public AnnotationMetadataProvider(ResourceStore store, Reporter reporter) {
        this(store, new CoreModuleProvider(), reporter);
    }

    public AnnotationMetadataProvider(ResourceStore store, ModuleProvider provider, Reporter reporter) {
        this(store, Bindings.newBindingRegistry(reporter, store, provider), reporter);
    }

    public AnnotationMetadataProvider(ResourceStore store, BindingRegistry registry, Reporter reporter) {
        this.m_store = store;
        this.m_registry = registry;
        this.m_reporter = reporter;
    }

    @Override
    public List<Element> getMetadatas() throws IOException {
        final ArrayList<Element> metadata = new ArrayList<Element>();
        this.m_store.accept(new ResourceVisitor(){

            @Override
            public void visit(String name) {
                if (name.endsWith(".class")) {
                    byte[] data = null;
                    try {
                        data = AnnotationMetadataProvider.this.m_store.read(name);
                    }
                    catch (IOException e) {
                        AnnotationMetadataProvider.this.m_reporter.warn("Cannot read content of %s", name);
                    }
                    if (data != null && data.length > 0) {
                        AnnotationMetadataProvider.this.computeAnnotations(name, data, metadata);
                    } else {
                        AnnotationMetadataProvider.this.m_reporter.error("Cannot compute annotations from %s : Empty file", name);
                    }
                }
            }
        });
        return metadata;
    }

    private void computeAnnotations(String name, byte[] bytecode, List<Element> metadata) {
        ClassReader cr = new ClassReader(bytecode);
        ClassMetadataCollector collector = new ClassMetadataCollector(this.m_registry, this.m_reporter);
        cr.accept(collector, 0);
        if (collector.getComponentMetadata() != null) {
            metadata.add(collector.getComponentMetadata());
            Element instance = collector.getInstanceMetadata();
            if (instance != null) {
                this.m_reporter.trace("Declaring an instance of %s", instance.getAttribute("component"));
                metadata.add(instance);
            }
        }
    }
}

