/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.lib.osgi.FileResource;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipResource
implements Resource {
    ZipFile zip;
    ZipEntry entry;
    long lastModified;
    String extra;

    ZipResource(ZipFile zip, ZipEntry entry, long lastModified) {
        this.zip = zip;
        this.entry = entry;
        this.lastModified = lastModified;
        byte[] data = entry.getExtra();
        if (data != null) {
            this.extra = new String(data);
        }
    }

    public InputStream openInputStream() throws IOException {
        return this.zip.getInputStream(this.entry);
    }

    public String toString() {
        return ":" + this.zip.getName() + "(" + this.entry.getName() + "):";
    }

    public static ZipFile build(Jar jar, File file) throws ZipException, IOException {
        return ZipResource.build(jar, file, null);
    }

    public static ZipFile build(Jar jar, File file, Pattern pattern) throws ZipException, IOException {
        try {
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                Matcher m;
                ZipEntry entry = e.nextElement();
                if (pattern != null && !(m = pattern.matcher(entry.getName())).matches() || entry.isDirectory()) continue;
                long time = entry.getTime();
                if (time <= 0L) {
                    time = file.lastModified();
                }
                jar.putResource(entry.getName(), new ZipResource(zip, entry, time), true);
            }
            return zip;
        }
        catch (ZipException ze) {
            throw new ZipException("The JAR/ZIP file (" + file.getAbsolutePath() + ") seems corrupted, error: " + ze.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Problem opening JAR: " + file.getAbsolutePath());
        }
    }

    public void write(OutputStream out) throws Exception {
        FileResource.copy(this, out);
    }

    public long lastModified() {
        return this.lastModified;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}

