/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.dependency.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.ipojo.dependency.interceptors.TransformedServiceReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformedServiceReferenceImpl<S>
implements TransformedServiceReference<S> {
    private final ServiceReference<S> m_origin;
    private Map<String, Object> m_properties = new HashMap<String, Object>();

    public TransformedServiceReferenceImpl(ServiceReference<S> origin) {
        this.m_origin = origin;
        for (String key : origin.getPropertyKeys()) {
            this.m_properties.put(key, origin.getProperty(key));
        }
    }

    @Override
    public TransformedServiceReferenceImpl<S> addProperty(String name, Object value) {
        if (FORBIDDEN_KEYS.contains(name)) {
            throw new IllegalArgumentException("Cannot change the property " + name);
        }
        this.m_properties.put(name, value);
        return this;
    }

    @Override
    public TransformedServiceReference<S> addPropertyIfAbsent(String name, Object value) {
        if (!this.contains(name)) {
            this.addProperty(name, value);
        }
        return this;
    }

    @Override
    public Object get(String name) {
        return this.m_properties.get(name);
    }

    @Override
    public TransformedServiceReferenceImpl<S> removeProperty(String name) {
        if (FORBIDDEN_KEYS.contains(name)) {
            throw new IllegalArgumentException("Cannot change the property " + name);
        }
        this.m_properties.put(name, null);
        return this;
    }

    @Override
    public boolean contains(String name) {
        return this.m_properties.get(name) != null;
    }

    @Override
    public ServiceReference<S> getWrappedReference() {
        if (this.m_origin instanceof TransformedServiceReferenceImpl) {
            return ((TransformedServiceReferenceImpl)this.m_origin).getWrappedReference();
        }
        return this.m_origin;
    }

    public Object getProperty(String key) {
        return this.m_properties.get(key);
    }

    public String[] getPropertyKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.m_properties.entrySet()) {
            if (entry.getValue() == null) continue;
            keys.add(entry.getKey());
        }
        return keys.toArray(new String[keys.size()]);
    }

    public Bundle getBundle() {
        return this.m_origin.getBundle();
    }

    public Bundle[] getUsingBundles() {
        return this.m_origin.getUsingBundles();
    }

    public boolean isAssignableTo(Bundle bundle, String className) {
        return this.m_origin.isAssignableTo(bundle, className);
    }

    public int compareTo(Object reference) {
        Integer otherRank;
        Long otherId;
        ServiceReference other = (ServiceReference)reference;
        Long id = (Long)this.getProperty("service.id");
        if (id.equals(otherId = (Long)other.getProperty("service.id"))) {
            return 0;
        }
        Object rankObj = this.getProperty("service.ranking");
        Object otherRankObj = other.getProperty("service.ranking");
        rankObj = rankObj == null ? new Integer(0) : rankObj;
        otherRankObj = otherRankObj == null ? new Integer(0) : otherRankObj;
        Integer rank = rankObj instanceof Integer ? (Integer)rankObj : new Integer(0);
        Integer n = otherRank = otherRankObj instanceof Integer ? (Integer)otherRankObj : new Integer(0);
        if (rank.compareTo(otherRank) < 0) {
            return -1;
        }
        if (rank.compareTo(otherRank) > 0) {
            return 1;
        }
        return id.compareTo(otherId) < 0 ? 1 : -1;
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceReference) {
            Object id1 = ((ServiceReference)o).getProperty("service.id");
            Object id2 = this.getProperty("service.id");
            return id1 != null && id1.equals(id2) || id1 == id2;
        }
        return this.m_origin.equals(o);
    }

    public int hashCode() {
        return this.m_origin.hashCode();
    }

    public String toString() {
        return this.getWrappedReference().toString() + this.m_properties;
    }
}

