/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.processor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.configuration.Instance;
import org.apache.felix.ipojo.extender.internal.BundleProcessor;
import org.apache.felix.ipojo.extender.internal.Extender;
import org.apache.felix.ipojo.extender.internal.declaration.DefaultInstanceDeclaration;
import org.apache.felix.ipojo.extender.internal.declaration.DefaultTypeDeclaration;
import org.apache.felix.ipojo.extender.internal.processor.ConfigurationAnnotationScanner;
import org.apache.felix.ipojo.util.Log;
import org.apache.felix.ipojo.util.Reflection;
import org.apache.felix.ipojo.util.StreamUtils;
import org.objectweb.asm.ClassReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationProcessor
implements BundleProcessor {
    private final Log m_logger;
    private final Map<Bundle, ComponentsAndInstances> m_registry = new HashMap<Bundle, ComponentsAndInstances>();
    private final boolean m_enabled;

    public ConfigurationProcessor(Log logger) {
        this.m_logger = logger;
        try {
            this.getClass().getClassLoader().loadClass("org.osgi.framework.wiring.BundleWiring");
        }
        catch (ClassNotFoundException e) {
            this.m_logger.log(1, "The org.osgi.framework.wiring.BundleWiring class is not provided by the framework, configuration processor disabled.");
            this.m_enabled = false;
            return;
        }
        this.m_enabled = true;
    }

    public static String getClassNameFromResource(String resource) {
        String res = resource;
        if (resource.startsWith("/")) {
            res = resource.substring(1);
        }
        res = res.substring(0, res.length() - ".class".length());
        return res.replace("/", ".");
    }

    @Override
    public void activate(Bundle bundle) {
        if (!this.m_enabled && Extender.getIPOJOBundleContext().getBundle().getBundleId() == bundle.getBundleId()) {
            return;
        }
        String imports = (String)bundle.getHeaders().get("Import-Package");
        if (imports == null || !imports.contains("org.apache.felix.ipojo.configuration")) {
            return;
        }
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            this.m_logger.log(1, "The bundle " + bundle.getBundleId() + " (" + bundle.getSymbolicName() + ") " + "cannot be adapted to BundleWiring, state: " + bundle.getState());
            return;
        }
        Collection resources = wiring.listResources("/", "*.class", 3);
        if (resources == null) {
            this.m_logger.log(1, "The bundle " + bundle.getBundleId() + " (" + bundle.getSymbolicName() + ") " + " does not have any classes to be analyzed");
            return;
        }
        this.m_logger.log(4, resources.size() + " classes found");
        this.handleResources(bundle, resources, wiring.getClassLoader());
    }

    @Override
    public void deactivate(Bundle bundle) {
        if (!this.m_enabled) {
            return;
        }
        ComponentsAndInstances cai = this.m_registry.remove(bundle);
        if (cai != null) {
            cai.stop();
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    private void handleResources(Bundle bundle, Collection<String> resources, ClassLoader classLoader) {
        for (String resource : resources) {
            this.handleResource(bundle, resource, classLoader);
        }
    }

    private void handleResource(Bundle bundle, String resource, ClassLoader classLoader) {
        URL url = classLoader.getResource(resource);
        if (url == null) {
            this.m_logger.log(1, "The resource " + resource + " cannot be loaded by " + bundle.getBundleId() + " " + "(" + bundle.getSymbolicName() + ")");
            return;
        }
        try {
            if (this.hasConfigurationAnnotation(bundle, url, classLoader)) {
                this.instantiateAndDeclareInstances(bundle, resource, classLoader);
            }
        }
        catch (IOException e) {
            this.m_logger.log(1, "The resource " + resource + " cannot be loaded by " + bundle.getBundleId() + " " + "(" + bundle.getSymbolicName() + ")", e);
        }
    }

    private void instantiateAndDeclareInstances(Bundle bundle, String resource, ClassLoader classLoader) {
        String classname = ConfigurationProcessor.getClassNameFromResource(resource);
        ArrayList<Instance> instances = new ArrayList<Instance>();
        try {
            Class<?> clazz = classLoader.loadClass(classname);
            Object configuration = clazz.newInstance();
            Map fields = Reflection.fields().ofType(Instance.class).in(configuration).map();
            for (Map.Entry entry : fields.entrySet()) {
                Instance instance = (Instance)entry.getValue();
                instance.nameIfUnnamed(entry.getKey().getName()).with("instance.bundle.context").setto(bundle.getBundleContext());
                instances.add(instance);
            }
            Map methods = Reflection.methods().in(configuration).ofReturnType(Instance.class).withParameter(BundleContext.class).map(bundle.getBundleContext());
            methods.putAll(Reflection.methods().in(configuration).ofReturnType(Instance.class).map(new Object[0]));
            for (Map.Entry entry : methods.entrySet()) {
                Instance instance = (Instance)entry.getValue().get();
                if (instance == null) {
                    this.m_logger.log(1, "The Instance declaration creation failed because the method " + entry.getKey().getName() + " of class " + entry.getKey().getDeclaringClass() + " threw an " + "exception", entry.getValue().error());
                    continue;
                }
                instance.nameIfUnnamed(entry.getKey().getName()).with("instance.bundle.context").setto(bundle.getBundleContext());
                instances.add(instance);
            }
        }
        catch (ClassNotFoundException e) {
            this.m_logger.log(1, "Cannot load class " + classname + " despite it was considered as a " + "configuration", e);
            return;
        }
        catch (InstantiationException e) {
            this.m_logger.log(1, "Cannot instantiate class " + classname + " despite it was considered as a " + "configuration", e);
            return;
        }
        catch (IllegalAccessException e) {
            this.m_logger.log(1, "Cannot instantiate class " + classname + " despite it was considered as a " + "configuration", e);
            return;
        }
        this.m_logger.log(2, instances.size() + " instances found in class " + classname);
        for (Instance instance : instances) {
            DefaultInstanceDeclaration declaration = new DefaultInstanceDeclaration(bundle.getBundleContext(), instance.factory(), instance.configuration());
            declaration.start();
            this.getComponentsAndInstances((Bundle)bundle).m_instances.add(declaration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasConfigurationAnnotation(Bundle bundle, URL url, ClassLoader classLoader) throws IOException {
        InputStream is = url.openStream();
        try {
            if (url.toExternalForm().contains("$")) {
                boolean bl = false;
                return bl;
            }
            ClassReader reader = new ClassReader(is);
            ConfigurationAnnotationScanner scanner = new ConfigurationAnnotationScanner();
            reader.accept(scanner, 0);
            boolean bl = scanner.isConfiguration();
            return bl;
        }
        finally {
            StreamUtils.closeQuietly(is);
        }
    }

    private ComponentsAndInstances getComponentsAndInstances(Bundle bundle) {
        ComponentsAndInstances cai = this.m_registry.get(bundle);
        if (cai == null) {
            cai = new ComponentsAndInstances();
            this.m_registry.put(bundle, cai);
        }
        return cai;
    }

    private static class ComponentsAndInstances {
        List<DefaultTypeDeclaration> m_types = new ArrayList<DefaultTypeDeclaration>();
        List<DefaultInstanceDeclaration> m_instances = new ArrayList<DefaultInstanceDeclaration>();

        private ComponentsAndInstances() {
        }

        void stop() {
            for (DefaultInstanceDeclaration instance : this.m_instances) {
                instance.stop();
            }
            for (DefaultTypeDeclaration declaration : this.m_types) {
                declaration.stop();
            }
            this.m_instances.clear();
            this.m_types.clear();
        }
    }
}

