/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.command;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.felix.ipojo.junit4osgi.OSGiJunitRunner;
import org.apache.felix.ipojo.junit4osgi.command.ResultCellRenderer;
import org.apache.felix.ipojo.junit4osgi.command.ResultTableModel;
import org.apache.felix.ipojo.junit4osgi.command.TestListModel;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingRunner
extends JFrame
implements BundleListener {
    private static final long serialVersionUID = 1L;
    private BundleContext m_context;
    private OSGiJunitRunner m_runner;
    private boolean m_running = false;
    private JButton m_allButton;
    private JButton m_executeButton;
    private JLabel m_executedResults;
    private JScrollPane m_message;
    private JTextArea m_messageArea;
    private JButton m_ok;
    private JPanel m_panel;
    private JProgressBar m_progress;
    private JDialog m_resultDialog;
    private JScrollPane m_resultScroll;
    private JTable m_resultTable;
    private JPanel m_statusBar;
    private JList m_suiteList;
    private JScrollPane m_suiteScroll;

    public SwingRunner(BundleContext bc) {
        this.m_context = bc;
    }

    public void start() {
        this.initComponents();
        this.setVisible(true);
        this.m_resultDialog.setVisible(false);
        this.refreshSuites();
        this.m_context.addBundleListener((BundleListener)this);
        this.m_executedResults.setText(" \t No executed tests");
        this.m_progress.setIndeterminate(false);
        this.m_progress.setMaximum(100);
        this.m_progress.setValue(100);
        TableColumn column = null;
        for (int i = 0; i < this.m_resultTable.getColumnCount(); ++i) {
            column = this.m_resultTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(350);
                continue;
            }
            column.setPreferredWidth(50);
            column.setCellRenderer(new ResultCellRenderer());
        }
    }

    public void stop() {
        this.m_context.removeBundleListener((BundleListener)this);
        this.dispose();
    }

    private void refreshSuites() {
        List list = this.m_runner.getTests();
        TestListModel lm = (TestListModel)this.m_suiteList.getModel();
        lm.clear();
        for (Test t : list) {
            lm.addTest(t);
        }
    }

    private void initComponents() {
        this.m_resultDialog = new JDialog();
        this.m_message = new JScrollPane();
        this.m_messageArea = new JTextArea();
        this.m_ok = new JButton();
        this.m_panel = new JPanel();
        this.m_suiteScroll = new JScrollPane();
        this.m_suiteList = new JList();
        this.m_allButton = new JButton();
        this.m_executeButton = new JButton();
        this.m_resultScroll = new JScrollPane();
        this.m_resultTable = new JTable();
        this.m_statusBar = new JPanel();
        this.m_progress = new JProgressBar();
        this.m_executedResults = new JLabel();
        this.m_resultDialog.setDefaultCloseOperation(0);
        this.m_resultDialog.setMinimumSize(new Dimension(320, 250));
        this.m_resultDialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                SwingRunner.this.onDialogClosed(evt);
            }

            public void windowClosing(WindowEvent evt) {
                SwingRunner.this.onDialogClosed(evt);
            }
        });
        this.m_message.setBorder(null);
        this.m_message.setMinimumSize(new Dimension(300, 202));
        this.m_message.setPreferredSize(new Dimension(300, 202));
        this.m_messageArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.m_messageArea.setColumns(20);
        this.m_messageArea.setEditable(false);
        this.m_messageArea.setLineWrap(true);
        this.m_messageArea.setRows(5);
        this.m_messageArea.setWrapStyleWord(true);
        this.m_messageArea.setMinimumSize(new Dimension(300, 250));
        this.m_messageArea.setPreferredSize(new Dimension(250, 200));
        this.m_message.setViewportView(this.m_messageArea);
        this.m_resultDialog.getContentPane().add((Component)this.m_message, "Center");
        this.m_ok.setText("Ok");
        this.m_ok.setPreferredSize(new Dimension(120, 23));
        this.m_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SwingRunner.this.okActionPerformed(evt);
            }
        });
        this.m_resultDialog.getContentPane().add((Component)this.m_ok, "South");
        this.setDefaultCloseOperation(2);
        this.setTitle("Junit Runner");
        this.setMinimumSize(new Dimension(580, 580));
        this.getContentPane().setLayout(new GridBagLayout());
        this.m_panel.setMinimumSize(new Dimension(580, 560));
        this.m_panel.setPreferredSize(new Dimension(580, 566));
        this.m_panel.setLayout(new GridBagLayout());
        this.m_suiteScroll.setAutoscrolls(true);
        this.m_suiteScroll.setMinimumSize(new Dimension(400, 147));
        this.m_suiteScroll.setPreferredSize(new Dimension(400, 147));
        this.m_suiteList.setModel(new TestListModel());
        this.m_suiteList.setMaximumSize(new Dimension(250, 147));
        this.m_suiteList.setMinimumSize(new Dimension(250, 147));
        this.m_suiteList.setPreferredSize(new Dimension(250, 147));
        this.m_suiteScroll.setViewportView(this.m_suiteList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.m_panel.add((Component)this.m_suiteScroll, gridBagConstraints);
        this.m_allButton.setText("Select All");
        this.m_allButton.setMaximumSize(new Dimension(90, 23));
        this.m_allButton.setMinimumSize(new Dimension(90, 23));
        this.m_allButton.setPreferredSize(new Dimension(90, 23));
        this.m_allButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SwingRunner.this.allButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.m_panel.add((Component)this.m_allButton, gridBagConstraints);
        this.m_executeButton.setText("Execute");
        this.m_executeButton.setMaximumSize(new Dimension(90, 23));
        this.m_executeButton.setMinimumSize(new Dimension(90, 23));
        this.m_executeButton.setPreferredSize(new Dimension(90, 23));
        this.m_executeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SwingRunner.this.executeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.m_panel.add((Component)this.m_executeButton, gridBagConstraints);
        this.m_resultScroll.setVerticalScrollBarPolicy(22);
        this.m_resultScroll.setMinimumSize(new Dimension(452, 402));
        this.m_resultTable.setFont(new Font("Tahoma", 0, 10));
        this.m_resultTable.setModel(new ResultTableModel());
        this.m_resultTable.setAutoResizeMode(4);
        this.m_resultTable.setMaximumSize(new Dimension(300, 400));
        this.m_resultTable.setMinimumSize(new Dimension(300, 400));
        this.m_resultTable.setPreferredSize(null);
        this.m_resultTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SwingRunner.this.resultTableMouseClicked(evt);
            }
        });
        this.m_resultScroll.setViewportView(this.m_resultTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 3, 3, 3);
        this.m_panel.add((Component)this.m_resultScroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.m_panel, gridBagConstraints);
        this.m_statusBar.setLayout(new BoxLayout(this.m_statusBar, 2));
        this.m_progress.setIndeterminate(true);
        this.m_statusBar.add(this.m_progress);
        this.m_executedResults.setText("aaaaaaaaaaaaaaa");
        this.m_statusBar.add(this.m_executedResults);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.m_statusBar, gridBagConstraints);
        this.pack();
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        if (this.m_running) {
            return;
        }
        int[] indices = this.m_suiteList.getSelectedIndices();
        ArrayList<Test> list = new ArrayList<Test>(indices.length);
        TestListModel model = (TestListModel)this.m_suiteList.getModel();
        for (int i = 0; i < indices.length; ++i) {
            list.add(model.getTestElementAt(indices[i]));
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.executeTest(list);
    }

    private void allButtonActionPerformed(ActionEvent evt) {
        int max = this.m_suiteList.getModel().getSize();
        int[] indices = new int[max];
        for (int i = 0; i < max; ++i) {
            indices[i] = i;
        }
        this.m_suiteList.setSelectedIndices(indices);
    }

    private void resultTableMouseClicked(MouseEvent evt) {
        Point p = evt.getPoint();
        int row = this.m_resultTable.rowAtPoint(p);
        int col = this.m_resultTable.columnAtPoint(p);
        ResultTableModel model = (ResultTableModel)this.m_resultTable.getModel();
        String message = model.getMessage(row, col);
        if (message != null) {
            this.setEnabled(false);
            this.m_resultDialog.setTitle("Test Report");
            this.m_messageArea.setText(message);
            this.m_resultDialog.setVisible(true);
        }
    }

    private void okActionPerformed(ActionEvent evt) {
        this.m_resultDialog.setVisible(false);
        this.setEnabled(true);
    }

    private void onDialogClosed(WindowEvent evt) {
        this.m_resultDialog.setVisible(false);
        this.setEnabled(true);
    }

    private void executeTest(final List<Test> list) {
        Runnable thread = new Runnable(){

            public void run() {
                ResultTableModel model = (ResultTableModel)SwingRunner.this.m_resultTable.getModel();
                SwingRunner.this.m_running = true;
                SwingRunner.this.m_executeButton.setText("Running...");
                SwingRunner.this.m_progress.setIndeterminate(true);
                model.clear();
                for (int i = 0; i < list.size(); ++i) {
                    TestResult tr = new TestResult();
                    tr.addListener((TestListener)new MyTestListener());
                    ((Test)list.get(i)).run(tr);
                }
                SwingRunner.this.m_running = false;
                SwingRunner.this.m_progress.setIndeterminate(false);
                SwingRunner.this.m_progress.setMaximum(100);
                SwingRunner.this.m_progress.setValue(100);
                SwingRunner.this.m_executeButton.setText("Execute");
                SwingRunner.this.computeExecutedTest();
                SwingRunner.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        new Thread(thread).start();
    }

    private void computeExecutedTest() {
        ResultTableModel results = (ResultTableModel)this.m_resultTable.getModel();
        String m = " \t ";
        m = m + results.getTestCount() + " tests executed / ";
        m = m + results.getSucess() + " sucess / ";
        m = m + results.getFailures() + " failures / ";
        m = m + results.getErrors() + " errors ";
        this.m_executedResults.setText(m);
    }

    public void bundleChanged(BundleEvent arg0) {
        this.refreshSuites();
    }

    private class MyTestListener
    implements TestListener {
        ResultTableModel m_model;

        private MyTestListener() {
            this.m_model = (ResultTableModel)SwingRunner.this.m_resultTable.getModel();
        }

        public void addError(Test arg0, Throwable arg1) {
            this.m_model.addTest(arg0, arg1);
            this.adjustScroll();
        }

        public void addFailure(Test arg0, AssertionFailedError arg1) {
            this.m_model.addTest(arg0, arg1);
            this.adjustScroll();
        }

        public void endTest(Test arg0) {
            this.m_model.addTest(arg0);
            this.adjustScroll();
        }

        public void startTest(Test arg0) {
        }

        private void adjustScroll() {
            JScrollBar bar = SwingRunner.this.m_resultScroll.getVerticalScrollBar();
            if (bar != null && bar.isVisible()) {
                bar.setValue(Integer.MAX_VALUE);
            }
        }
    }
}

