/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.annotations;

import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.metadata.Element;

public class FilteredDependency
extends OSGiTestCase {
    private Element[] deps;
    private Element[] froms;
    private IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.FilteredDependency");
        this.deps = meta.getElements("requires");
        Element meta2 = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.FromDependency");
        this.froms = meta2.getElements("requires");
    }

    public void testField() {
        Element dep = this.getDependencyById(this.deps, "fs");
        String opt = dep.getAttribute("filter");
        FilteredDependency.assertEquals((String)"Check filter", (String)"(foo=bar)", (String)opt);
    }

    public void testCallbackBind() {
        Element dep = this.getDependencyById(this.deps, "Bar");
        String opt = dep.getAttribute("filter");
        FilteredDependency.assertEquals((String)"Check filter", (String)"(foo=bar)", (String)opt);
    }

    public void testCallbackUnbind() {
        Element dep = this.getDependencyById(this.deps, "Baz");
        String opt = dep.getAttribute("filter");
        FilteredDependency.assertEquals((String)"Check filter", (String)"(foo=bar)", (String)opt);
    }

    public void testBoth() {
        Element dep = this.getDependencyById(this.deps, "inv");
        String opt = dep.getAttribute("filter");
        FilteredDependency.assertEquals((String)"Check filter", (String)"(foo=bar)", (String)opt);
    }

    public void testBindOnly() {
        Element dep = this.getDependencyById(this.deps, "bindonly");
        String opt = dep.getAttribute("filter");
        FilteredDependency.assertEquals((String)"Check filter", (String)"(foo=bar)", (String)opt);
    }

    public void testUnbindOnly() {
        Element dep = this.getDependencyById(this.deps, "unbindonly");
        String opt = dep.getAttribute("filter");
        FilteredDependency.assertEquals((String)"Check filter", (String)"(foo=bar)", (String)opt);
    }

    public void testFromField() {
        Element dep = this.getDependencyById(this.froms, "fs");
        String from = dep.getAttribute("from");
        FilteredDependency.assertEquals((String)"Check from", (String)"X", (String)from);
    }

    public void testFromBind() {
        Element dep = this.getDependencyById(this.froms, "fs2");
        String from = dep.getAttribute("from");
        FilteredDependency.assertEquals((String)"Check from", (String)"X", (String)from);
    }

    public void testFromUnbind() {
        Element dep = this.getDependencyById(this.froms, "inv");
        String from = dep.getAttribute("from");
        FilteredDependency.assertEquals((String)"Check from", (String)"X", (String)from);
    }

    public void testNoFrom() {
        Element dep = this.getDependencyById(this.froms, "Bar");
        String from = dep.getAttribute("from");
        FilteredDependency.assertNull((String)"Check from", (Object)from);
    }

    private Element getDependencyById(Element[] deps, String name) {
        int i = 0;
        while (i < deps.length) {
            String na = deps[i].getAttribute("id");
            String field = deps[i].getAttribute("field");
            if (na != null && na.equalsIgnoreCase(name)) {
                return deps[i];
            }
            if (field != null && field.equalsIgnoreCase(name)) {
                return deps[i];
            }
            ++i;
        }
        FilteredDependency.fail((String)("Dependency  " + name + " not found"));
        return null;
    }
}

