/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.remote;

import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

class ServiceMediator {
    private final String m_bundleName;
    private final long m_bundleId;
    private final BundleContext m_context;
    private final ServiceTracker m_logTracker;
    private final ServiceTracker m_shellTracker;
    private final ServiceTracker m_cpTracker;
    public static long WAIT_UNLIMITED = 0L;
    public static long NO_WAIT = -1L;

    ServiceMediator(BundleContext context) {
        this.m_context = context;
        this.m_bundleName = this.m_context.getBundle().getSymbolicName() == null ? this.m_context.getBundle().getLocation() : this.m_context.getBundle().getSymbolicName();
        this.m_bundleId = this.m_context.getBundle().getBundleId();
        this.m_logTracker = new ServiceTracker(this.m_context, "org.osgi.service.log.LogService", null);
        this.m_logTracker.open();
        this.m_shellTracker = new ServiceTracker(this.m_context, "org.apache.felix.shell.ShellService", null);
        this.m_shellTracker.open();
        this.m_cpTracker = new ServiceTracker(this.m_context, "org.apache.felix.service.command.CommandProcessor", null);
        this.m_cpTracker.open();
    }

    public Object getCommandProcessor(long wait) {
        Object svcObj = null;
        try {
            svcObj = wait < 0L ? this.m_cpTracker.getService() : this.m_cpTracker.waitForService(wait);
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.err);
        }
        return svcObj;
    }

    public Object getShellService(long wait) {
        Object svcObj = null;
        try {
            svcObj = wait < 0L ? this.m_shellTracker.getService() : this.m_shellTracker.waitForService(wait);
            return svcObj;
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.err);
            return svcObj;
        }
    }

    public Object getLogService(long wait) {
        Object svcObj = null;
        try {
            svcObj = wait < 0L ? this.m_logTracker.getService() : this.m_logTracker.waitForService(wait);
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.err);
        }
        return svcObj;
    }

    public void info(String msg) {
        Object log = this.getLogService(NO_WAIT);
        if (log != null) {
            ((LogService)log).log(3, msg);
        } else {
            this.sysout(msg);
        }
    }

    public void error(String msg, Throwable t) {
        Object log = this.getLogService(NO_WAIT);
        if (log != null) {
            ((LogService)log).log(1, msg);
        } else {
            this.syserr(msg, t);
        }
    }

    public void error(String msg) {
        Object log = this.getLogService(NO_WAIT);
        if (log != null) {
            ((LogService)log).log(1, msg);
        } else {
            this.syserr(msg, null);
        }
    }

    public void debug(String msg) {
        Object log = this.getLogService(NO_WAIT);
        if (log != null) {
            ((LogService)log).log(4, msg);
        } else {
            this.sysout(msg);
        }
    }

    public void warn(String msg) {
        Object log = this.getLogService(NO_WAIT);
        if (log != null) {
            ((LogService)log).log(2, msg);
        } else {
            this.syserr(msg, null);
        }
    }

    private void sysout(String msg) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.m_bundleName);
        sbuf.append(" [");
        sbuf.append(this.m_bundleId);
        sbuf.append("] ");
        sbuf.append(msg);
        System.out.println(sbuf.toString());
    }

    private void syserr(String msg, Throwable t) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.m_bundleName);
        sbuf.append(" [");
        sbuf.append(this.m_bundleId);
        sbuf.append("] ");
        sbuf.append(msg);
        System.err.println(sbuf.toString());
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    public void deactivate() {
        if (this.m_logTracker != null) {
            this.m_logTracker.close();
        }
        this.m_shellTracker.close();
        this.m_cpTracker.close();
    }
}

