/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp;

import org.cybergarage.net.HostInterface;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.util.Debug;
import org.cybergarage.xml.Parser;

public class UPnP {
    public static final String XML_CLASS_PROPERTTY = "cyberlink.upnp.xml.parser";
    public static final String NAME = "CyberDomo";
    public static final String VERSION = "1.8";
    public static final int SERVER_RETRY_COUNT = 100;
    public static final int DEFAULT_EXPIRED_DEVICE_EXTRA_TIME = 60;
    public static final String INMPR03 = "INMPR03";
    public static final String INMPR03_VERSION = "1.0";
    public static final int INMPR03_DISCOVERY_OVER_WIRELESS_COUNT = 4;
    public static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    public static final int USE_ONLY_IPV6_ADDR = 1;
    public static final int USE_LOOPBACK_ADDR = 2;
    public static final int USE_IPV6_LINK_LOCAL_SCOPE = 3;
    public static final int USE_IPV6_SUBNET_SCOPE = 4;
    public static final int USE_IPV6_ADMINISTRATIVE_SCOPE = 5;
    public static final int USE_IPV6_SITE_LOCAL_SCOPE = 6;
    public static final int USE_IPV6_GLOBAL_SCOPE = 7;
    public static final int USE_SSDP_SEARCHRESPONSE_MULTIPLE_INTERFACES = 8;
    public static final int USE_ONLY_IPV4_ADDR = 9;
    private static Parser xmlParser;
    public static final int DEFAULT_TTL = 4;
    private static int timeToLive;

    public static final String getServerName() {
        String osName = System.getProperty("os.name");
        String osVer = System.getProperty("os.version");
        return osName + "/" + osVer + " UPnP/1.0 " + NAME + "/" + VERSION;
    }

    public static final void setEnable(int value) {
        switch (value) {
            case 1: {
                HostInterface.USE_ONLY_IPV6_ADDR = true;
                break;
            }
            case 9: {
                HostInterface.USE_ONLY_IPV4_ADDR = true;
                break;
            }
            case 2: {
                HostInterface.USE_LOOPBACK_ADDR = true;
                break;
            }
            case 3: {
                SSDP.setIPv6Address("FF02::C");
                break;
            }
            case 4: {
                SSDP.setIPv6Address("FF03::C");
                break;
            }
            case 5: {
                SSDP.setIPv6Address("FF04::C");
                break;
            }
            case 6: {
                SSDP.setIPv6Address("FF05::C");
                break;
            }
            case 7: {
                SSDP.setIPv6Address("FF0E::C");
            }
        }
    }

    public static final void setDisable(int value) {
        switch (value) {
            case 1: {
                HostInterface.USE_ONLY_IPV6_ADDR = false;
                break;
            }
            case 9: {
                HostInterface.USE_ONLY_IPV4_ADDR = false;
                break;
            }
            case 2: {
                HostInterface.USE_LOOPBACK_ADDR = false;
            }
        }
    }

    public static final boolean isEnabled(int value) {
        switch (value) {
            case 1: {
                return HostInterface.USE_ONLY_IPV6_ADDR;
            }
            case 9: {
                return HostInterface.USE_ONLY_IPV4_ADDR;
            }
            case 2: {
                return HostInterface.USE_LOOPBACK_ADDR;
            }
        }
        return false;
    }

    private static final String toUUID(int seed) {
        String id = Integer.toString(seed & 0xFFFF, 16);
        int idLen = id.length();
        String uuid = "";
        for (int n = 0; n < 4 - idLen; ++n) {
            uuid = uuid + "0";
        }
        uuid = uuid + id;
        return uuid;
    }

    public static final String createUUID() {
        long time1 = System.currentTimeMillis();
        long time2 = (long)((double)System.currentTimeMillis() * Math.random());
        return UPnP.toUUID((int)(time1 & 0xFFFFL)) + "-" + UPnP.toUUID((int)(time1 >> 32 | 0xA000L) & 0xFFFF) + "-" + UPnP.toUUID((int)(time2 & 0xFFFFL)) + "-" + UPnP.toUUID((int)(time2 >> 32 | 0xE000L) & 0xFFFF);
    }

    public static final void setXMLParser(Parser parser) {
        xmlParser = parser;
    }

    public static final Parser getXMLParser() {
        if (xmlParser == null && (xmlParser = UPnP.loadDefaultXMLParser()) == null) {
            throw new RuntimeException("No XML parser defined. And unable to laod any. \nTry to invoke UPnP.setXMLParser before UPnP.getXMLParser");
        }
        return xmlParser;
    }

    private static Parser loadDefaultXMLParser() {
        Parser parser = null;
        String[] parserClass = new String[]{System.getProperty(XML_CLASS_PROPERTTY), "org.cybergarage.xml.parser.JaxpParser", "org.cybergarage.xml.parser.kXML2Parser", "org.cybergarage.xml.parser.XercesParser"};
        for (int i = 0; i < parserClass.length; ++i) {
            if (parserClass[i] == null) continue;
            try {
                parser = (Parser)Class.forName(parserClass[i]).newInstance();
                return parser;
            }
            catch (Throwable e) {
                Debug.warning("Unable to load " + parserClass[i] + " as XMLParser due to " + e);
            }
        }
        return null;
    }

    public static final void setTimeToLive(int value) {
        timeToLive = value;
    }

    public static final int getTimeToLive() {
        return timeToLive;
    }

    public static final void initialize() {
    }

    static {
        timeToLive = 4;
        UPnP.setTimeToLive(4);
    }
}

