/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.filestore;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.useradmin.RoleFactory;
import org.apache.felix.useradmin.filestore.StubGroupImpl;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;

final class RoleRepositorySerializer {
    private static final int VALUE_TYPE_STRING = 1;
    private static final int VALUE_TYPE_BARRAY = 2;

    RoleRepositorySerializer() {
    }

    public Map deserialize(InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null!");
        }
        return this.readRepository(new DataInputStream(is));
    }

    public void serialize(Map roleRepository, OutputStream os) throws IOException {
        if (roleRepository == null) {
            throw new IllegalArgumentException("Map cannot be null!");
        }
        if (os == null) {
            throw new IllegalArgumentException("OutputStream cannot be null!");
        }
        this.writeRepository(roleRepository, new DataOutputStream(os));
    }

    private void addGroups(Map repository, List stubGroups) throws IOException {
        Iterator sgIter = stubGroups.iterator();
        while (sgIter.hasNext()) {
            StubGroupImpl stubGroup = (StubGroupImpl)sgIter.next();
            Group group = (Group)RoleFactory.createRole((int)2, (String)stubGroup.getName());
            this.copyDictionary(stubGroup.getProperties(), group.getProperties());
            this.copyDictionary(stubGroup.getCredentials(), group.getCredentials());
            repository.put(group.getName(), group);
        }
        int origSize = stubGroups.size();
        while (!stubGroups.isEmpty()) {
            ArrayList copy = new ArrayList(stubGroups);
            int size = copy.size();
            for (int i = 0; i < size; ++i) {
                StubGroupImpl stubGroup = (StubGroupImpl)copy.get(i);
                Group group = (Group)repository.get(stubGroup.getName());
                if (group == null) continue;
                this.resolveGroupMembers(stubGroup, group, repository);
                stubGroups.remove(stubGroup);
            }
            if (origSize == stubGroups.size()) {
                throw new IOException("Failed to resolve groups: " + stubGroups);
            }
            origSize = stubGroups.size();
        }
    }

    private Map convertToMap(Dictionary dictionary) {
        HashMap result = new HashMap();
        if (dictionary instanceof Map) {
            result.putAll((Map)((Object)dictionary));
        } else {
            Enumeration keyEnum = dictionary.keys();
            while (keyEnum.hasMoreElements()) {
                Object key = keyEnum.nextElement();
                result.put(key, dictionary.get(key));
            }
        }
        return result;
    }

    private void copyDictionary(Dictionary source, Dictionary dest) {
        Enumeration keys = source.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = source.get(key);
            dest.put(key, value);
        }
    }

    private Role getRoleFromRepository(Map repository, String name) {
        Role role = "user.anyone".equals(name) ? RoleFactory.createRole((String)"user.anyone") : (Role)repository.get(name);
        return role;
    }

    private void readDictionary(Dictionary dict, DataInputStream dis) throws IOException {
        int count = dis.readInt();
        while (count-- > 0) {
            String key = dis.readUTF();
            int type = dis.read();
            if (2 == type) {
                int length = dis.readInt();
                byte[] value = new byte[length];
                if (dis.read(value, 0, length) != length) {
                    throw new IOException("Invalid repository; failed to correctly read dictionary!");
                }
                dict.put(key, value);
                continue;
            }
            if (1 != type) continue;
            dict.put(key, dis.readUTF());
        }
    }

    private StubGroupImpl readGroup(DataInputStream dis) throws IOException {
        StubGroupImpl group = new StubGroupImpl(dis.readUTF());
        this.readDictionary(group.getProperties(), dis);
        this.readDictionary(group.getCredentials(), dis);
        int count = dis.readInt();
        while (count-- > 0) {
            group.addMember(dis.readUTF());
        }
        count = dis.readInt();
        while (count-- > 0) {
            group.addRequiredMember(dis.readUTF());
        }
        return group;
    }

    private Map readRepository(DataInputStream dis) throws IOException {
        HashMap<String, User> repository = new HashMap<String, User>();
        int entryCount = dis.readInt();
        ArrayList<StubGroupImpl> stubGroups = new ArrayList<StubGroupImpl>();
        while (entryCount-- > 0) {
            int type = dis.readInt();
            Object role = null;
            if (2 == type) {
                stubGroups.add(this.readGroup(dis));
            } else {
                role = 1 == type ? this.readUser(dis) : this.readRole(dis);
            }
            if (role == null) continue;
            repository.put(role.getName(), (User)role);
        }
        this.addGroups(repository, stubGroups);
        return repository;
    }

    private Role readRole(DataInputStream dis) throws IOException {
        Role role = RoleFactory.createRole((int)0, (String)dis.readUTF());
        this.readDictionary(role.getProperties(), dis);
        return role;
    }

    private User readUser(DataInputStream dis) throws IOException {
        User user = (User)RoleFactory.createRole((int)1, (String)dis.readUTF());
        this.readDictionary(user.getProperties(), dis);
        this.readDictionary(user.getCredentials(), dis);
        return user;
    }

    private void resolveGroupMembers(StubGroupImpl stubGroup, Group group, Map repository) throws IOException {
        Role role;
        String name;
        int i;
        List names = stubGroup.getMemberNames();
        int size = names.size();
        for (i = 0; i < size; ++i) {
            name = (String)names.get(i);
            role = this.getRoleFromRepository(repository, name);
            if (role == null) {
                throw new IOException("Unable to find referenced basic member: " + name);
            }
            group.addMember(role);
        }
        names = stubGroup.getRequiredMemberNames();
        size = names.size();
        for (i = 0; i < size; ++i) {
            name = (String)names.get(i);
            role = this.getRoleFromRepository(repository, name);
            if (role == null) {
                throw new IOException("Unable to find referenced required member: " + name);
            }
            group.addRequiredMember(role);
        }
    }

    private void writeDictionary(Dictionary dict, DataOutputStream dos) throws IOException {
        Map properties = this.convertToMap(dict);
        Set entries = properties.entrySet();
        int size = entries.size();
        dos.writeInt(size);
        Iterator entriesIter = entries.iterator();
        while (entriesIter.hasNext()) {
            Map.Entry entry = entriesIter.next();
            dos.writeUTF((String)entry.getKey());
            Object value = entry.getValue();
            if (value instanceof String) {
                dos.write(1);
                dos.writeUTF((String)value);
                continue;
            }
            if (!(value instanceof byte[])) continue;
            dos.write(2);
            dos.writeInt(((byte[])value).length);
            dos.write((byte[])value);
        }
    }

    private void writeGroup(Group group, DataOutputStream dos) throws IOException {
        int i;
        dos.writeUTF(group.getName());
        this.writeDictionary(group.getProperties(), dos);
        this.writeDictionary(group.getCredentials(), dos);
        Role[] m = group.getMembers();
        if (m == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(m.length);
            for (i = 0; i < m.length; ++i) {
                dos.writeUTF(m[i].getName());
            }
        }
        m = group.getRequiredMembers();
        if (m == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(m.length);
            for (i = 0; i < m.length; ++i) {
                dos.writeUTF(m[i].getName());
            }
        }
    }

    private void writeRepository(Map repository, DataOutputStream dos) throws IOException {
        Collection values = repository.values();
        Iterator valuesIter = values.iterator();
        dos.writeInt(values.size());
        while (valuesIter.hasNext()) {
            Role role = (Role)valuesIter.next();
            int type = role.getType();
            dos.writeInt(type);
            if (2 == type) {
                this.writeGroup((Group)role, dos);
                continue;
            }
            if (1 == type) {
                this.writeUser((User)role, dos);
                continue;
            }
            this.writeRole(role, dos);
        }
    }

    private void writeRole(Role role, DataOutputStream dos) throws IOException {
        dos.writeUTF(role.getName());
        this.writeDictionary(role.getProperties(), dos);
    }

    private void writeUser(User user, DataOutputStream dos) throws IOException {
        dos.writeUTF(user.getName());
        this.writeDictionary(user.getProperties(), dos);
        this.writeDictionary(user.getCredentials(), dos);
    }
}

