/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.filter;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import org.apache.felix.webconsole.internal.filter.ResourceFilteringWriter;
import org.apache.felix.webconsole.servlet.RequestVariableResolver;

public class FilteringResponseWrapper
extends HttpServletResponseWrapper {
    private final ResourceBundle locale;
    private final ServletRequest request;
    private PrintWriter writer;

    public FilteringResponseWrapper(HttpServletResponse response, ResourceBundle locale, ServletRequest request) {
        super(response);
        this.locale = locale;
        this.request = request;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            PrintWriter base = super.getWriter();
            if (this.doWrap()) {
                RequestVariableResolver vars = (RequestVariableResolver)this.request.getAttribute("felix.webconsole.variable.resolver");
                ResourceFilteringWriter filter = new ResourceFilteringWriter(base, this.locale, vars);
                this.writer = new PrintWriter(filter);
            } else {
                this.writer = base;
            }
        }
        return this.writer;
    }

    private final boolean doWrap() {
        return this.getContentType() != null && this.getContentType().indexOf("text/html") >= 0;
    }
}

