/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.DeadlineTimeoutException;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDeadlineTimeoutException {
    TestDeadlineTimeoutException() {
    }

    @Test
    void testMessage() {
        Deadline deadline = Deadline.fromUnixMilliseconds((long)1000L).freeze();
        Assertions.assertTrue((boolean)deadline.isExpired(), (String)deadline.toString());
        String format = deadline.formatTarget();
        TimeValue diff = TimeValue.ofMilliseconds((long)deadline.remaining());
        Assertions.assertEquals((Object)("Deadline: " + format + ", " + diff + " overdue"), (Object)DeadlineTimeoutException.from((Deadline)deadline).getMessage());
    }

    @Test
    void testInfiniteDeadlineMessage() {
        Deadline deadline = Deadline.calculate((TimeValue)Timeout.ZERO_MILLISECONDS);
        Assertions.assertEquals((Object)"No deadline (infinite)", (Object)DeadlineTimeoutException.from((Deadline)deadline).getMessage());
    }
}

