/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partitiondistribution;

import org.apache.ignite.internal.tostring.S;

public class Assignment {
    private final String consistentId;
    private final boolean isPeer;

    private Assignment(String consistentId, boolean isPeer) {
        this.consistentId = consistentId;
        this.isPeer = isPeer;
    }

    public static Assignment forPeer(String consistentId) {
        return new Assignment(consistentId, true);
    }

    public static Assignment forLearner(String consistentId) {
        return new Assignment(consistentId, false);
    }

    public String consistentId() {
        return this.consistentId;
    }

    public boolean isPeer() {
        return this.isPeer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assignment that = (Assignment)o;
        if (this.isPeer != that.isPeer) {
            return false;
        }
        return this.consistentId.equals(that.consistentId);
    }

    public int hashCode() {
        int result = this.consistentId.hashCode();
        result = 31 * result + (this.isPeer ? 1 : 0);
        return result;
    }

    public String toString() {
        return S.toString(Assignment.class, (Object)this);
    }
}

