/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache.scan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.management.cache.scan.CacheScanTaskFormat;
import org.apache.ignite.internal.management.cache.scan.DefaultCacheScanTaskFormat;

public class TableCacheScanTaskFormat
implements CacheScanTaskFormat {
    public static final String NAME = "table";
    private List<String> keyTitles;
    private List<String> valTitles;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public List<String> titles(Cache.Entry<Object, Object> first) {
        this.keyTitles = this.titles(first.getKey(), "Key");
        this.valTitles = this.titles(first.getValue(), "Value");
        ArrayList<String> res = new ArrayList<String>(this.keyTitles.size() + this.valTitles.size());
        res.addAll(this.keyTitles);
        res.addAll(this.valTitles);
        return res;
    }

    @Override
    public List<?> row(Cache.Entry<Object, Object> e) {
        ArrayList<String> res = new ArrayList<String>(this.keyTitles.size() + this.valTitles.size());
        res.addAll(this.columns(e.getKey(), this.keyTitles, "Key"));
        res.addAll(this.columns(e.getValue(), this.valTitles, "Value"));
        return res;
    }

    private List<String> titles(Object o, String dflt) {
        if (o instanceof BinaryObject) {
            BinaryObject b = (BinaryObject)o;
            ArrayList<String> flds = new ArrayList<String>(b.type().fieldNames());
            Collections.sort(flds);
            return flds;
        }
        return Collections.singletonList(dflt);
    }

    private Collection<String> columns(Object o, List<String> titles, String dfltTitle) {
        if (titles.size() == 1 && titles.get(0).equals(dfltTitle)) {
            return Collections.singletonList(DefaultCacheScanTaskFormat.valueOf(o));
        }
        String[] res = new String[titles.size()];
        if (o instanceof BinaryObject) {
            BinaryObject b = (BinaryObject)o;
            for (int i = 0; i < titles.size(); ++i) {
                if (!b.hasField(titles.get(i))) continue;
                res[i] = DefaultCacheScanTaskFormat.valueOf(b.field(titles.get(i)));
            }
        }
        return Arrays.asList(res);
    }
}

