/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.meta;

import java.util.function.Consumer;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.meta.MetaUpdateCommandArg;
import org.apache.ignite.internal.management.meta.MetadataMarshalled;
import org.apache.ignite.internal.management.meta.MetadataUpdateTask;
import org.apache.ignite.lang.IgniteExperimental;

@IgniteExperimental
public class MetaUpdateCommand
implements ComputeCommand<MetaUpdateCommandArg, MetadataMarshalled> {
    @Override
    public String description() {
        return "Update cluster metadata from specified file (file name is required)";
    }

    @Override
    public Class<MetaUpdateCommandArg> argClass() {
        return MetaUpdateCommandArg.class;
    }

    @Override
    public Class<MetadataUpdateTask> taskClass() {
        return MetadataUpdateTask.class;
    }

    @Override
    public void printResult(MetaUpdateCommandArg arg, MetadataMarshalled res, Consumer<String> printer) {
        if (res.metadata() == null) {
            printer.accept("Type not found");
            return;
        }
        BinaryMetadata m = res.metadata();
        printer.accept("Metadata updated for the type: '" + m.typeName() + "'");
    }

    @Override
    public String confirmationPrompt(MetaUpdateCommandArg arg) {
        return "Warning: the command will update the binary metadata at the cluster.";
    }
}

