/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller.optimized;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectInputStream;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectOutputStream;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectStreamRegistry;
import org.apache.ignite.internal.util.typedef.internal.U;

public class OptimizedObjectPooledStreamRegistry
extends OptimizedObjectStreamRegistry {
    private final BlockingQueue<OptimizedObjectOutputStream> outPool;
    private final BlockingQueue<OptimizedObjectInputStream> inPool;

    OptimizedObjectPooledStreamRegistry(int size) {
        assert (size > 0) : "size must be positive for pooled stream registry: " + size;
        this.outPool = new LinkedBlockingQueue<OptimizedObjectOutputStream>(size);
        this.inPool = new LinkedBlockingQueue<OptimizedObjectInputStream>(size);
        for (int i = 0; i < size; ++i) {
            this.outPool.offer(OptimizedObjectPooledStreamRegistry.createOut());
            this.inPool.offer(OptimizedObjectPooledStreamRegistry.createIn());
        }
    }

    @Override
    OptimizedObjectOutputStream out() throws IgniteInterruptedCheckedException {
        try {
            return this.outPool.take();
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException("Failed to take output object stream from pool (thread interrupted).", e);
        }
    }

    @Override
    OptimizedObjectInputStream in() throws IgniteInterruptedCheckedException {
        try {
            return this.inPool.take();
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException("Failed to take input object stream from pool (thread interrupted).", e);
        }
    }

    @Override
    void closeOut(OptimizedObjectOutputStream out) {
        U.close(out, null);
        boolean b = this.outPool.offer(out);
        assert (b);
    }

    @Override
    void closeIn(OptimizedObjectInputStream in) {
        U.close(in, null);
        boolean b = this.inPool.offer(in);
        assert (b);
    }
}

