/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.extras;

import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesMvccEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesMvccObsoleteTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtrasAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridCacheAttributesMvccTtlEntryExtras
extends GridCacheEntryExtrasAdapter {
    private GridCacheMvcc mvcc;
    private long ttl;
    private long expireTime;

    GridCacheAttributesMvccTtlEntryExtras(GridCacheMvcc mvcc, long ttl, long expireTime) {
        assert (mvcc != null);
        assert (expireTime != 0L);
        this.mvcc = mvcc;
        this.ttl = ttl;
        this.expireTime = expireTime;
    }

    @Override
    public GridCacheMvcc mvcc() {
        return this.mvcc;
    }

    @Override
    public GridCacheEntryExtras mvcc(@Nullable GridCacheMvcc mvcc) {
        if (mvcc != null) {
            this.mvcc = mvcc;
            return this;
        }
        return new GridCacheAttributesTtlEntryExtras(this.ttl, this.expireTime);
    }

    @Override
    public GridCacheEntryExtras obsoleteVersion(GridCacheVersion obsoleteVer) {
        return obsoleteVer != null ? new GridCacheAttributesMvccObsoleteTtlEntryExtras(this.mvcc, obsoleteVer, this.ttl, this.expireTime) : this;
    }

    @Override
    public long ttl() {
        return this.ttl;
    }

    @Override
    public long expireTime() {
        return this.expireTime;
    }

    @Override
    public GridCacheEntryExtras ttlAndExpireTime(long ttl, long expireTime) {
        if (expireTime != 0L) {
            this.ttl = ttl;
            this.expireTime = expireTime;
            return this;
        }
        return new GridCacheAttributesMvccEntryExtras(this.mvcc);
    }

    @Override
    public int size() {
        return 24;
    }

    public String toString() {
        return S.toString(GridCacheAttributesMvccTtlEntryExtras.class, this);
    }
}

