/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.binarytuple;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite3.internal.binarytuple.BinaryTupleBuilder;

public class BinaryTuplePrefixBuilder
extends BinaryTupleBuilder {
    private final int prefixNumElements;

    public BinaryTuplePrefixBuilder(int prefixNumElements, int fullNumElements) {
        super(fullNumElements);
        this.prefixNumElements = prefixNumElements;
    }

    public BinaryTuplePrefixBuilder(int prefixNumElements, int fullNumElements, int totalValueSize) {
        super(fullNumElements, totalValueSize);
        assert (fullNumElements >= prefixNumElements);
        this.prefixNumElements = prefixNumElements;
    }

    @Override
    protected ByteBuffer buildInternal() {
        int elementIndex = this.elementIndex();
        if (elementIndex != this.prefixNumElements) {
            throw new IllegalStateException(String.format("Unexpected amount of elements in a BinaryTuple prefix. Expected: %d, actual %d", this.prefixNumElements, elementIndex));
        }
        int numElements = this.numElements();
        while (this.elementIndex() < numElements) {
            this.appendNull();
        }
        ByteBuffer tuple = super.buildInternal();
        byte flags = tuple.get(tuple.position());
        flags = (byte)(flags | 8);
        tuple.put(tuple.position(), flags);
        if (tuple.capacity() - tuple.limit() < 4) {
            tuple = ByteBuffer.allocate(tuple.remaining() + 4).order(ByteOrder.LITTLE_ENDIAN).put(tuple).putInt(this.prefixNumElements).flip();
        } else {
            int prevLimit = tuple.limit();
            tuple.limit(prevLimit + 4).putInt(prevLimit, this.prefixNumElements);
        }
        return tuple;
    }
}

