/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.ignite3.compute.BroadcastExecution;
import org.apache.ignite3.compute.JobExecution;
import org.apache.ignite3.internal.compute.AntiHijackJobExecution;
import org.apache.ignite3.internal.thread.PublicApiThreading;

class AntiHijackBroadcastExecution<R>
implements BroadcastExecution<R> {
    private final BroadcastExecution<R> execution;
    private final Executor asyncContinuationExecutor;

    AntiHijackBroadcastExecution(BroadcastExecution<R> execution, Executor asyncContinuationExecutor) {
        this.execution = execution;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public Collection<JobExecution<R>> executions() {
        return this.execution.executions().stream().map(execution -> new AntiHijackJobExecution(execution, this.asyncContinuationExecutor)).collect(Collectors.toList());
    }

    @Override
    public CompletableFuture<Collection<R>> resultsAsync() {
        return this.preventThreadHijack(this.execution.resultsAsync());
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, this.asyncContinuationExecutor);
    }
}

