/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.schema;

import java.util.Collections;
import java.util.List;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.partition.replicator.schema.ColumnDefinitionDiff;

public class TableDefinitionDiff {
    private static final TableDefinitionDiff EMPTY = new TableDefinitionDiff(-1, -1, "name", "name", Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    private final int oldSchemaVersion;
    private final int newSchemaVersion;
    private final boolean nameDiffers;
    private final List<CatalogTableColumnDescriptor> addedColumns;
    private final List<CatalogTableColumnDescriptor> removedColumns;
    private final List<ColumnDefinitionDiff> changedColumns;

    public static TableDefinitionDiff empty() {
        return EMPTY;
    }

    public TableDefinitionDiff(int oldSchemaVersion, int newSchemaVersion, String oldName, String newName, List<CatalogTableColumnDescriptor> addedColumns, List<CatalogTableColumnDescriptor> removedColumns, List<ColumnDefinitionDiff> changedColumns) {
        this.oldSchemaVersion = oldSchemaVersion;
        this.newSchemaVersion = newSchemaVersion;
        this.nameDiffers = !oldName.equals(newName);
        this.addedColumns = List.copyOf(addedColumns);
        this.removedColumns = List.copyOf(removedColumns);
        this.changedColumns = List.copyOf(changedColumns);
    }

    public int oldSchemaVersion() {
        return this.oldSchemaVersion;
    }

    public int newSchemaVersion() {
        return this.newSchemaVersion;
    }

    public boolean nameDiffers() {
        return this.nameDiffers;
    }

    public List<CatalogTableColumnDescriptor> addedColumns() {
        return this.addedColumns;
    }

    public List<CatalogTableColumnDescriptor> removedColumns() {
        return this.removedColumns;
    }

    public List<ColumnDefinitionDiff> changedColumns() {
        return this.changedColumns;
    }
}

