/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.util.FastCrc;
import org.apache.ignite3.raft.jraft.entity.LogEntry;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryEncoder;

class SegmentPayload {
    static final int GROUP_ID_SIZE_BYTES = 8;
    static final int LENGTH_SIZE_BYTES = 4;
    static final int HASH_SIZE = 4;
    private final long groupId;
    private final int payloadSize;
    private final LogEntry logEntry;
    private final LogEntryEncoder logEntryEncoder;

    SegmentPayload(long groupId, LogEntry logEntry, LogEntryEncoder logEntryEncoder) {
        this.groupId = groupId;
        this.logEntry = logEntry;
        this.logEntryEncoder = logEntryEncoder;
        this.payloadSize = logEntryEncoder.size(logEntry);
    }

    void writeTo(ByteBuffer buffer) {
        int originalPos = buffer.position();
        buffer.putLong(this.groupId).putInt(this.payloadSize);
        this.logEntryEncoder.encode(buffer, this.logEntry);
        int dataSize = buffer.position() - originalPos;
        buffer.position(originalPos);
        int crc = FastCrc.calcCrc(buffer, dataSize);
        buffer.putInt(crc);
    }

    int size() {
        return SegmentPayload.overheadSize() + this.payloadSize;
    }

    static int overheadSize() {
        return 16;
    }
}

