/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel.agg;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteHashAggregateBase;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteMapAggregateBase;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.PlanUtils;

public class IgniteMapHashAggregate
extends IgniteMapAggregateBase
implements IgniteHashAggregateBase {
    private static final String REL_TYPE_NAME = "MapHashAggregate";

    public IgniteMapHashAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
    }

    public IgniteMapHashAggregate(RelInput input) {
        super(input);
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new IgniteMapHashAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteMapHashAggregate(cluster, this.getTraitSet(), (RelNode)IgniteMapHashAggregate.sole(inputs), this.getGroupSet(), (List<ImmutableBitSet>)this.getGroupSets(), this.getAggCallList());
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    protected RelDataType deriveRowType() {
        IgniteTypeFactory typeFactory = (IgniteTypeFactory)this.getCluster().getTypeFactory();
        return PlanUtils.createHashAggRowType((List<ImmutableBitSet>)this.groupSets, typeFactory, this.input.getRowType(), this.aggCalls);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.computeSelfCostHash(planner, mq);
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }
}

