/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.gc;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionDataStorage;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.gc.GcEntry;
import org.apache.ignite3.internal.table.distributed.gc.IntHolder;
import org.apache.ignite3.internal.table.distributed.index.IndexUpdateHandler;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.PendingComparableValuesTracker;

public class GcUpdateHandler {
    private final PartitionDataStorage storage;
    private final IndexUpdateHandler indexUpdateHandler;
    private final PendingComparableValuesTracker<HybridTimestamp, Void> safeTimeTracker;

    public GcUpdateHandler(PartitionDataStorage storage, PendingComparableValuesTracker<HybridTimestamp, Void> safeTimeTracker, IndexUpdateHandler indexUpdateHandler) {
        this.storage = storage;
        this.indexUpdateHandler = indexUpdateHandler;
        this.safeTimeTracker = safeTimeTracker;
    }

    public PendingComparableValuesTracker<HybridTimestamp, Void> getSafeTimeTracker() {
        return this.safeTimeTracker;
    }

    public boolean vacuumBatch(HybridTimestamp lowWatermark, int count, boolean strict) {
        if (count <= 0) {
            return true;
        }
        IntHolder countHolder = new IntHolder(count);
        block5: while (countHolder.get() > 0) {
            VacuumResult vacuumResult = this.internalVacuumBatch(lowWatermark, countHolder);
            switch (vacuumResult) {
                case NO_GARBAGE_LEFT: {
                    return false;
                }
                case SUCCESS: {
                    return true;
                }
                case FAILED_ACQUIRE_LOCK: {
                    if (strict) continue block5;
                    return true;
                }
            }
            throw new IllegalStateException(vacuumResult.toString());
        }
        return true;
    }

    private VacuumResult internalVacuumBatch(HybridTimestamp lowWatermark, IntHolder countHolder) {
        return this.storage.runConsistently(locker -> {
            int count = countHolder.get();
            for (int i = 0; i < count; ++i) {
                VacuumResult vacuumResult = this.internalVacuum(lowWatermark, locker, i > 0);
                if (vacuumResult != VacuumResult.SUCCESS) {
                    return vacuumResult;
                }
                countHolder.getAndDecrement();
            }
            return VacuumResult.SUCCESS;
        });
    }

    private VacuumResult internalVacuum(HybridTimestamp lowWatermark, MvPartitionStorage.Locker locker, boolean useTryLock) {
        RowId rowId;
        GcEntry gcEntry;
        BinaryRow binaryRow;
        do {
            if ((gcEntry = this.storage.peek(lowWatermark)) == null) {
                return VacuumResult.NO_GARBAGE_LEFT;
            }
            rowId = gcEntry.getRowId();
            if (useTryLock) {
                if (locker.tryLock(rowId)) continue;
                return VacuumResult.FAILED_ACQUIRE_LOCK;
            }
            locker.lock(rowId);
        } while ((binaryRow = this.storage.vacuum(gcEntry)) == null);
        try (Cursor<ReadResult> cursor = this.storage.scanVersions(rowId);){
            this.indexUpdateHandler.tryRemoveFromIndexes(binaryRow, rowId, cursor, null);
        }
        return VacuumResult.SUCCESS;
    }

    private static enum VacuumResult {
        SUCCESS,
        NO_GARBAGE_LEFT,
        FAILED_ACQUIRE_LOCK;

    }
}

