/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.raft.snapshot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.lowwatermark.LowWatermark;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionMvStorageAccess;
import org.apache.ignite3.internal.raft.RaftGroupConfiguration;
import org.apache.ignite3.internal.raft.RaftGroupConfigurationConverter;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowUpgrader;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.storage.AddWriteCommittedResult;
import org.apache.ignite3.internal.storage.AddWriteCommittedResultStatus;
import org.apache.ignite3.internal.storage.AddWriteResult;
import org.apache.ignite3.internal.storage.AddWriteResultStatus;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.TxIdMismatchException;
import org.apache.ignite3.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite3.internal.storage.engine.MvTableStorage;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.table.distributed.gc.GcUpdateHandler;
import org.apache.ignite3.internal.table.distributed.gc.MvGc;
import org.apache.ignite3.internal.table.distributed.index.IndexUpdateHandler;
import org.apache.ignite3.internal.table.distributed.raft.snapshot.FullStateTransferIndexChooser;
import org.apache.ignite3.internal.table.distributed.raft.snapshot.IndexIdAndBinaryRow;
import org.apache.ignite3.internal.table.distributed.raft.snapshot.IndexIdAndTableVersion;
import org.apache.ignite3.internal.tx.TransactionIds;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class PartitionMvStorageAccessImpl
implements PartitionMvStorageAccess {
    private final int partitionId;
    private final MvTableStorage mvTableStorage;
    private final RaftGroupConfigurationConverter raftGroupConfigurationConverter = new RaftGroupConfigurationConverter();
    private final MvGc mvGc;
    private final IndexUpdateHandler indexUpdateHandler;
    private final GcUpdateHandler gcUpdateHandler;
    private final FullStateTransferIndexChooser fullStateTransferIndexChooser;
    private final SchemaRegistry schemaRegistry;
    private final LowWatermark lowWatermark;

    public PartitionMvStorageAccessImpl(int partitionId, MvTableStorage mvTableStorage, MvGc mvGc, IndexUpdateHandler indexUpdateHandler, GcUpdateHandler gcUpdateHandler, FullStateTransferIndexChooser fullStateTransferIndexChooser, SchemaRegistry schemaRegistry, LowWatermark lowWatermark) {
        this.partitionId = partitionId;
        this.mvTableStorage = mvTableStorage;
        this.mvGc = mvGc;
        this.indexUpdateHandler = indexUpdateHandler;
        this.gcUpdateHandler = gcUpdateHandler;
        this.fullStateTransferIndexChooser = fullStateTransferIndexChooser;
        this.schemaRegistry = schemaRegistry;
        this.lowWatermark = lowWatermark;
    }

    @Override
    public int partitionId() {
        return this.partitionId;
    }

    @Override
    public int tableId() {
        return this.mvTableStorage.getTableDescriptor().getId();
    }

    @Override
    @Nullable
    public RowId closestRowId(RowId lowerBound) {
        return this.getMvPartitionStorage().closestRowId(lowerBound);
    }

    @Override
    public List<ReadResult> getAllRowVersions(RowId rowId) {
        MvPartitionStorage mvPartitionStorage = this.getMvPartitionStorage();
        return mvPartitionStorage.runConsistently(locker -> {
            locker.lock(rowId);
            try (Cursor<ReadResult> cursor = mvPartitionStorage.scanVersions(rowId);){
                List list = cursor.stream().collect(Collectors.toList());
                return list;
            }
        });
    }

    @Override
    @Nullable
    public RaftGroupConfiguration committedGroupConfiguration() {
        byte[] configBytes = this.getMvPartitionStorage().committedGroupConfiguration();
        return this.raftGroupConfigurationConverter.fromBytes(configBytes);
    }

    @Override
    public void addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableOrZoneId, int commitPartitionId, int catalogVersion) {
        MvPartitionStorage mvPartitionStorage = this.getMvPartitionStorage();
        List<IndexIdAndTableVersion> indexIdAndTableVersionList = this.fullStateTransferIndexChooser.chooseForAddWrite(catalogVersion, this.tableId(), TransactionIds.beginTimestamp(txId));
        List<IndexIdAndBinaryRow> indexIdAndBinaryRowList = this.upgradeForEachTableVersion(row, indexIdAndTableVersionList);
        mvPartitionStorage.runConsistently(locker -> {
            locker.lock(rowId);
            AddWriteResult result = mvPartitionStorage.addWrite(rowId, row, txId, commitTableOrZoneId, commitPartitionId);
            if (result.status() == AddWriteResultStatus.TX_MISMATCH) {
                throw new TxIdMismatchException(result.currentWriteIntentTxId(), txId);
            }
            for (IndexIdAndBinaryRow indexIdAndBinaryRow : indexIdAndBinaryRowList) {
                this.indexUpdateHandler.addToIndex(indexIdAndBinaryRow.binaryRow(), rowId, indexIdAndBinaryRow.indexId());
            }
            return null;
        });
    }

    @Override
    public void addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp, int catalogVersion) {
        MvPartitionStorage mvPartitionStorage = this.getMvPartitionStorage();
        List<IndexIdAndTableVersion> indexIdAndTableVersionList = this.fullStateTransferIndexChooser.chooseForAddWriteCommitted(catalogVersion, this.tableId(), commitTimestamp);
        List<IndexIdAndBinaryRow> indexIdAndBinaryRowList = this.upgradeForEachTableVersion(row, indexIdAndTableVersionList);
        mvPartitionStorage.runConsistently(locker -> {
            locker.lock(rowId);
            AddWriteCommittedResult result = mvPartitionStorage.addWriteCommitted(rowId, row, commitTimestamp);
            if (result.status() == AddWriteCommittedResultStatus.WRITE_INTENT_EXISTS) {
                throw new StorageException("Write intent already exists: [rowId={}]", rowId);
            }
            for (IndexIdAndBinaryRow indexIdAndBinaryRow : indexIdAndBinaryRowList) {
                this.indexUpdateHandler.addToIndex(indexIdAndBinaryRow.binaryRow(), rowId, indexIdAndBinaryRow.indexId());
            }
            return null;
        });
    }

    @Override
    public long lastAppliedIndex() {
        return this.getMvPartitionStorage().lastAppliedIndex();
    }

    @Override
    public long lastAppliedTerm() {
        return this.getMvPartitionStorage().lastAppliedTerm();
    }

    @Override
    @Nullable
    public LeaseInfo leaseInfo() {
        return this.getMvPartitionStorage().leaseInfo();
    }

    @Override
    public CompletableFuture<Void> startRebalance() {
        return this.mvGc.removeStorage(this.tablePartitionId()).thenCompose(unused -> this.mvTableStorage.startRebalancePartition(this.partitionId()));
    }

    @Override
    public CompletableFuture<Void> abortRebalance() {
        return this.mvTableStorage.abortRebalancePartition(this.partitionId()).thenAccept(unused -> this.mvGc.addStorage(this.tablePartitionId(), this.gcUpdateHandler));
    }

    @Override
    public CompletableFuture<Void> finishRebalance(MvPartitionMeta partitionMeta) {
        return ((CompletableFuture)this.mvTableStorage.finishRebalancePartition(this.partitionId(), partitionMeta).thenAccept(v -> this.mvGc.addStorage(this.tablePartitionId(), this.gcUpdateHandler))).thenCompose(v -> this.getMvPartitionStorage().flush());
    }

    @Override
    @Nullable
    public RowId getNextRowIdToBuildIndex(int indexId) {
        return this.indexUpdateHandler.getNextRowIdToBuildIndex(indexId);
    }

    @Override
    public void setNextRowIdToBuildIndex(Map<Integer, RowId> nextRowIdToBuildByIndexId) {
        MvPartitionStorage mvPartitionStorage = this.getMvPartitionStorage();
        mvPartitionStorage.runConsistently(locker -> {
            nextRowIdToBuildByIndexId.forEach(this.indexUpdateHandler::setNextRowIdToBuildIndex);
            return null;
        });
    }

    @Override
    public void updateLowWatermark(HybridTimestamp newLowWatermark) {
        this.lowWatermark.updateLowWatermark(newLowWatermark);
    }

    private MvPartitionStorage getMvPartitionStorage() {
        int partitionId = this.partitionId();
        MvPartitionStorage mvPartitionStorage = this.mvTableStorage.getMvPartition(partitionId);
        assert (mvPartitionStorage != null) : IgniteStringFormatter.format("tableId={}, partitionId={}", this.tableId(), partitionId);
        return mvPartitionStorage;
    }

    private TablePartitionId tablePartitionId() {
        return new TablePartitionId(this.tableId(), this.partitionId);
    }

    private List<IndexIdAndBinaryRow> upgradeForEachTableVersion(@Nullable BinaryRow source, List<IndexIdAndTableVersion> indexIdAndTableVersionList) {
        if (source == null) {
            return List.of();
        }
        return indexIdAndTableVersionList.stream().map(indexIdAndTableVersion -> {
            BinaryRowUpgrader upgrader = new BinaryRowUpgrader(this.schemaRegistry, indexIdAndTableVersion.tableVersion());
            return new IndexIdAndBinaryRow(indexIdAndTableVersion.indexId(), upgrader.upgrade(source));
        }).collect(Collectors.toCollection(() -> new ArrayList(indexIdAndTableVersionList.size())));
    }
}

