/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.worker;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.thread.AbstractStripedThreadPoolExecutor;
import org.apache.ignite3.internal.thread.StripedExecutor;
import org.apache.ignite3.internal.worker.CriticalSingleThreadExecutor;
import org.apache.ignite3.internal.worker.CriticalWorker;

public class CriticalStripedThreadPoolExecutor
extends AbstractStripedThreadPoolExecutor<ExecutorService>
implements StripedExecutor {
    private final List<CriticalWorker> workers;

    public CriticalStripedThreadPoolExecutor(int concurrencyLvl, ThreadFactory threadFactory, boolean allowCoreThreadTimeOut, long keepAliveTime) {
        this(CriticalStripedThreadPoolExecutor.createExecutors(concurrencyLvl, threadFactory, allowCoreThreadTimeOut, keepAliveTime));
    }

    private CriticalStripedThreadPoolExecutor(CriticalSingleThreadExecutor[] executors) {
        super((ExecutorService[])executors);
        this.workers = Arrays.stream(executors).map(CriticalWorker.class::cast).collect(Collectors.toUnmodifiableList());
    }

    private static CriticalSingleThreadExecutor[] createExecutors(int concurrencyLvl, ThreadFactory threadFactory, boolean allowCoreThreadTimeOut, long keepAliveTime) {
        CriticalSingleThreadExecutor[] execs = new CriticalSingleThreadExecutor[concurrencyLvl];
        for (int i = 0; i < concurrencyLvl; ++i) {
            CriticalSingleThreadExecutor executor = new CriticalSingleThreadExecutor(keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
            executor.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
            execs[i] = executor;
        }
        return execs;
    }

    public Collection<CriticalWorker> workers() {
        return this.workers;
    }
}

